/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS48;

import org.apache.milagro.amcl.BLS48.BIG;
import org.apache.milagro.amcl.BLS48.ECP;
import org.apache.milagro.amcl.BLS48.ECP8;
import org.apache.milagro.amcl.BLS48.FP;
import org.apache.milagro.amcl.BLS48.FP16;
import org.apache.milagro.amcl.BLS48.FP2;
import org.apache.milagro.amcl.BLS48.FP48;
import org.apache.milagro.amcl.BLS48.FP8;
import org.apache.milagro.amcl.BLS48.ROM;

public final class PAIR256 {
    public static final boolean USE_GLV = true;
    public static final boolean USE_GS_G2 = true;
    public static final boolean USE_GS_GT = true;
    public static final boolean GT_STRONG = false;

    public static FP48 line(ECP8 A, ECP8 B, FP Qx, FP Qy) {
        FP16 c;
        FP16 b;
        FP16 a;
        if (A == B) {
            FP8 XX = new FP8(A.getx());
            FP8 YY = new FP8(A.gety());
            FP8 ZZ = new FP8(A.getz());
            FP8 YZ = new FP8(YY);
            YZ.mul(ZZ);
            XX.sqr();
            YY.sqr();
            ZZ.sqr();
            YZ.imul(4);
            YZ.neg();
            YZ.norm();
            YZ.tmul(Qy);
            XX.imul(6);
            XX.tmul(Qx);
            int sb = 51;
            ZZ.imul(sb);
            ZZ.times_i();
            ZZ.add(ZZ);
            YZ.times_i();
            YZ.norm();
            ZZ.norm();
            YY.add(YY);
            ZZ.sub(YY);
            ZZ.norm();
            a = new FP16(YZ, ZZ);
            b = new FP16(0);
            c = new FP16(XX);
            c.times_i();
            A.dbl();
        } else {
            FP8 X1 = new FP8(A.getx());
            FP8 Y1 = new FP8(A.gety());
            FP8 T1 = new FP8(A.getz());
            FP8 T2 = new FP8(A.getz());
            T1.mul(B.gety());
            T2.mul(B.getx());
            X1.sub(T2);
            X1.norm();
            Y1.sub(T1);
            Y1.norm();
            T1.copy(X1);
            X1.tmul(Qy);
            X1.times_i();
            X1.norm();
            T1.mul(B.gety());
            T2.copy(Y1);
            T2.mul(B.getx());
            T2.sub(T1);
            T2.norm();
            Y1.tmul(Qx);
            Y1.neg();
            Y1.norm();
            a = new FP16(X1, T2);
            b = new FP16(0);
            c = new FP16(Y1);
            c.times_i();
            A.add(B);
        }
        return new FP48(a, b, c);
    }

    public static FP48 ate(ECP8 P1, ECP Q1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP8 P = new ECP8(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        ECP8 A = new ECP8();
        FP48 r = new FP48(1);
        A.copy(P);
        ECP8 MP = new ECP8();
        MP.copy(P);
        MP.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP48 lv = PAIR256.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR256.line(A, P, Qx, Qy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR256.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
        }
        return r;
    }

    public static FP48 ate2(ECP8 P1, ECP Q1, ECP8 R1, ECP S1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP8 P = new ECP8(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        ECP8 R = new ECP8(R1);
        ECP S = new ECP(S1);
        R.affine();
        S.affine();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        FP Sx = new FP(S.getx());
        FP Sy = new FP(S.gety());
        ECP8 A = new ECP8();
        ECP8 B = new ECP8();
        FP48 r = new FP48(1);
        A.copy(P);
        B.copy(R);
        ECP8 MP = new ECP8();
        MP.copy(P);
        MP.neg();
        ECP8 MR = new ECP8();
        MR.copy(R);
        MR.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP48 lv = PAIR256.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR256.line(B, B, Sx, Sy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR256.line(A, P, Qx, Qy);
                r.smul(lv, 1);
                lv = PAIR256.line(B, R, Sx, Sy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR256.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR256.line(B, MR, Sx, Sy);
            r.smul(lv, 1);
        }
        return r;
    }

    public static FP48 fexp(FP48 m) {
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG x = new BIG(ROM.CURVE_Bnx);
        FP48 r = new FP48(m);
        FP48 lv = new FP48(r);
        lv.inverse();
        r.conj();
        r.mul(lv);
        lv.copy(r);
        r.frob(f, 8);
        r.mul(lv);
        FP48 t7 = new FP48(r);
        t7.usqr();
        FP48 t1 = t7.pow(x);
        x.fshr(1);
        FP48 t2 = t1.pow(x);
        x.fshl(1);
        FP48 t3 = new FP48(t1);
        t3.conj();
        t2.mul(t3);
        t2.mul(r);
        r.mul(t7);
        t1 = t2.pow(x);
        t3.copy(t1);
        t3.frob(f, 14);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 13);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 12);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 11);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 10);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 9);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 8);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t2);
        t3.conj();
        t1.mul(t3);
        t3.copy(t1);
        t3.frob(f, 7);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 6);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 5);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 4);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 3);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 2);
        r.mul(t3);
        t1 = t1.pow(x);
        t3.copy(t1);
        t3.frob(f, 1);
        r.mul(t3);
        t1 = t1.pow(x);
        r.mul(t1);
        t2.frob(f, 15);
        r.mul(t2);
        r.reduce();
        return r;
    }

    public static BIG[] glv(BIG e) {
        BIG[] u = new BIG[2];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG x2 = BIG.smul(x, x);
        x = BIG.smul(x2, x2);
        x2 = BIG.smul(x, x);
        u[0] = new BIG(e);
        u[0].mod(x2);
        u[1] = new BIG(e);
        u[1].div(x2);
        u[1].rsub(q);
        return u;
    }

    public static BIG[] gs(BIG e) {
        BIG[] u = new BIG[16];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG w = new BIG(e);
        for (int i = 0; i < 15; ++i) {
            u[i] = new BIG(w);
            u[i].mod(x);
            w.div(x);
        }
        u[15] = new BIG(w);
        return u;
    }

    public static ECP G1mul(ECP P, BIG e) {
        ECP R = new ECP();
        R.copy(P);
        ECP Q = new ECP();
        Q.copy(P);
        Q.affine();
        BIG q = new BIG(ROM.CURVE_Order);
        FP cru = new FP(new BIG(ROM.CURVE_Cru));
        BIG t = new BIG(0);
        BIG[] u = PAIR256.glv(e);
        Q.getx().mul(cru);
        int np = u[0].nbits();
        t.copy(BIG.modneg(u[0], q));
        int nn = t.nbits();
        if (nn < np) {
            u[0].copy(t);
            R.neg();
        }
        np = u[1].nbits();
        t.copy(BIG.modneg(u[1], q));
        nn = t.nbits();
        if (nn < np) {
            u[1].copy(t);
            Q.neg();
        }
        u[0].norm();
        u[1].norm();
        R = R.mul2(u[0], Q, u[1]);
        return R;
    }

    public static ECP8 G2mul(ECP8 P, BIG e) {
        int i;
        ECP8[] Q = new ECP8[16];
        FP2[] F = ECP8.frob_constants();
        BIG q = new BIG(ROM.CURVE_Order);
        BIG[] u = PAIR256.gs(e);
        BIG t = new BIG(0);
        Q[0] = new ECP8();
        Q[0].copy(P);
        for (i = 1; i < 16; ++i) {
            Q[i] = new ECP8();
            Q[i].copy(Q[i - 1]);
            Q[i].frob(F, 1);
        }
        for (i = 0; i < 16; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                Q[i].neg();
            }
            u[i].norm();
        }
        ECP8 R = ECP8.mul16(Q, u);
        return R;
    }

    public static FP48 GTpow(FP48 d, BIG e) {
        int i;
        FP48[] g = new FP48[16];
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG q = new BIG(ROM.CURVE_Order);
        BIG t = new BIG(0);
        BIG[] u = PAIR256.gs(e);
        g[0] = new FP48(d);
        for (i = 1; i < 16; ++i) {
            g[i] = new FP48(0);
            g[i].copy(g[i - 1]);
            g[i].frob(f, 1);
        }
        for (i = 0; i < 16; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                g[i].conj();
            }
            u[i].norm();
        }
        FP48 r = FP48.pow16(g, u);
        return r;
    }
}

