/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BN254;

import org.apache.milagro.amcl.BN254.BIG;
import org.apache.milagro.amcl.BN254.FP2;
import org.apache.milagro.amcl.BN254.FP4;
import org.apache.milagro.amcl.BN254.ROM;

public final class FP12 {
    private final FP4 a;
    private final FP4 b;
    private final FP4 c;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
        this.c.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
        this.c.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch() && this.c.iszilch();
    }

    public void cmove(FP12 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
        this.c.cmove(g.c, d);
    }

    public static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    public void select(FP12[] g, int b) {
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(g[0], FP12.teq(babs, 0));
        this.cmove(g[1], FP12.teq(babs, 1));
        this.cmove(g[2], FP12.teq(babs, 2));
        this.cmove(g[3], FP12.teq(babs, 3));
        this.cmove(g[4], FP12.teq(babs, 4));
        this.cmove(g[5], FP12.teq(babs, 5));
        this.cmove(g[6], FP12.teq(babs, 6));
        this.cmove(g[7], FP12.teq(babs, 7));
        FP12 invf = new FP12(this);
        invf.conj();
        this.cmove(invf, m & 1);
    }

    public boolean isunity() {
        FP4 one = new FP4(1);
        return this.a.equals(one) && this.b.iszilch() && this.c.iszilch();
    }

    public boolean equals(FP12 x) {
        return this.a.equals(x.a) && this.b.equals(x.b) && this.c.equals(x.c);
    }

    public FP4 geta() {
        return this.a;
    }

    public FP4 getb() {
        return this.b;
    }

    public FP4 getc() {
        return this.c;
    }

    public void copy(FP12 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
        this.c.copy(x.c);
    }

    public void one() {
        this.a.one();
        this.b.zero();
        this.c.zero();
    }

    public void conj() {
        this.a.conj();
        this.b.nconj();
        this.c.conj();
    }

    public FP12(FP4 d) {
        this.a = new FP4(d);
        this.b = new FP4(0);
        this.c = new FP4(0);
    }

    public FP12(int d) {
        this.a = new FP4(d);
        this.b = new FP4(0);
        this.c = new FP4(0);
    }

    public FP12(FP4 d, FP4 e, FP4 f) {
        this.a = new FP4(d);
        this.b = new FP4(e);
        this.c = new FP4(f);
    }

    public FP12(FP12 x) {
        this.a = new FP4(x.a);
        this.b = new FP4(x.b);
        this.c = new FP4(x.c);
    }

    public void usqr() {
        FP4 A = new FP4(this.a);
        FP4 B = new FP4(this.c);
        FP4 C = new FP4(this.b);
        FP4 D = new FP4(0);
        this.a.sqr();
        D.copy(this.a);
        D.add(this.a);
        this.a.add(D);
        this.a.norm();
        A.nconj();
        A.add(A);
        this.a.add(A);
        B.sqr();
        B.times_i();
        D.copy(B);
        D.add(B);
        B.add(D);
        B.norm();
        C.sqr();
        D.copy(C);
        D.add(C);
        C.add(D);
        C.norm();
        this.b.conj();
        this.b.add(this.b);
        this.c.nconj();
        this.c.add(this.c);
        this.b.add(B);
        this.c.add(C);
        this.reduce();
    }

    public void sqr() {
        FP4 A = new FP4(this.a);
        FP4 B = new FP4(this.b);
        FP4 C = new FP4(this.c);
        FP4 D = new FP4(this.a);
        A.sqr();
        B.mul(this.c);
        B.add(B);
        B.norm();
        C.sqr();
        D.mul(this.b);
        D.add(D);
        this.c.add(this.a);
        this.c.add(this.b);
        this.c.norm();
        this.c.sqr();
        this.a.copy(A);
        A.add(B);
        A.norm();
        A.add(C);
        A.add(D);
        A.norm();
        A.neg();
        B.times_i();
        C.times_i();
        this.a.add(B);
        this.b.copy(C);
        this.b.add(D);
        this.c.add(A);
        this.norm();
    }

    public void mul(FP12 y) {
        FP4 z0 = new FP4(this.a);
        FP4 z1 = new FP4(0);
        FP4 z2 = new FP4(this.b);
        FP4 z3 = new FP4(0);
        FP4 t0 = new FP4(this.a);
        FP4 t1 = new FP4(y.a);
        z0.mul(y.a);
        z2.mul(y.b);
        t0.add(this.b);
        t1.add(y.b);
        t0.norm();
        t1.norm();
        z1.copy(t0);
        z1.mul(t1);
        t0.copy(this.b);
        t0.add(this.c);
        t1.copy(y.b);
        t1.add(y.c);
        t0.norm();
        t1.norm();
        z3.copy(t0);
        z3.mul(t1);
        t0.copy(z0);
        t0.neg();
        t1.copy(z2);
        t1.neg();
        z1.add(t0);
        this.b.copy(z1);
        this.b.add(t1);
        z3.add(t1);
        z2.add(t0);
        t0.copy(this.a);
        t0.add(this.c);
        t1.copy(y.a);
        t1.add(y.c);
        t0.norm();
        t1.norm();
        t0.mul(t1);
        z2.add(t0);
        t0.copy(this.c);
        t0.mul(y.c);
        t1.copy(t0);
        t1.neg();
        this.c.copy(z2);
        this.c.add(t1);
        z3.add(t1);
        t0.times_i();
        this.b.add(t0);
        z3.norm();
        z3.times_i();
        this.a.copy(z0);
        this.a.add(z3);
        this.norm();
    }

    public void smul(FP12 y, int type) {
        FP4 z0;
        if (type == 0) {
            z0 = new FP4(this.a);
            FP4 z2 = new FP4(this.b);
            FP4 z3 = new FP4(this.b);
            FP4 t0 = new FP4(0);
            FP4 t1 = new FP4(y.a);
            z0.mul(y.a);
            z2.pmul(y.b.real());
            this.b.add(this.a);
            t1.real().add(y.b.real());
            t1.norm();
            this.b.norm();
            this.b.mul(t1);
            z3.add(this.c);
            z3.norm();
            z3.pmul(y.b.real());
            t0.copy(z0);
            t0.neg();
            t1.copy(z2);
            t1.neg();
            this.b.add(t0);
            this.b.add(t1);
            z3.add(t1);
            z2.add(t0);
            t0.copy(this.a);
            t0.add(this.c);
            t0.norm();
            z3.norm();
            t0.mul(y.a);
            this.c.copy(z2);
            this.c.add(t0);
            z3.times_i();
            this.a.copy(z0);
            this.a.add(z3);
        }
        if (type == 1) {
            z0 = new FP4(this.a);
            FP4 z1 = new FP4(0);
            FP4 z2 = new FP4(0);
            FP4 z3 = new FP4(0);
            FP4 t0 = new FP4(this.a);
            FP4 t1 = new FP4(0);
            z0.mul(y.a);
            t0.add(this.b);
            t0.norm();
            z1.copy(t0);
            z1.mul(y.a);
            t0.copy(this.b);
            t0.add(this.c);
            t0.norm();
            z3.copy(t0);
            z3.pmul(y.c.getb());
            z3.times_i();
            t0.copy(z0);
            t0.neg();
            z1.add(t0);
            this.b.copy(z1);
            z2.copy(t0);
            t0.copy(this.a);
            t0.add(this.c);
            t1.copy(y.a);
            t1.add(y.c);
            t0.norm();
            t1.norm();
            t0.mul(t1);
            z2.add(t0);
            t0.copy(this.c);
            t0.pmul(y.c.getb());
            t0.times_i();
            t1.copy(t0);
            t1.neg();
            this.c.copy(z2);
            this.c.add(t1);
            z3.add(t1);
            t0.times_i();
            this.b.add(t0);
            z3.norm();
            z3.times_i();
            this.a.copy(z0);
            this.a.add(z3);
        }
        this.norm();
    }

    public void inverse() {
        FP4 f0 = new FP4(this.a);
        FP4 f1 = new FP4(this.b);
        FP4 f2 = new FP4(this.a);
        FP4 f3 = new FP4(0);
        this.norm();
        f0.sqr();
        f1.mul(this.c);
        f1.times_i();
        f0.sub(f1);
        f0.norm();
        f1.copy(this.c);
        f1.sqr();
        f1.times_i();
        f2.mul(this.b);
        f1.sub(f2);
        f1.norm();
        f2.copy(this.b);
        f2.sqr();
        f3.copy(this.a);
        f3.mul(this.c);
        f2.sub(f3);
        f2.norm();
        f3.copy(this.b);
        f3.mul(f2);
        f3.times_i();
        this.a.mul(f0);
        f3.add(this.a);
        this.c.mul(f1);
        this.c.times_i();
        f3.add(this.c);
        f3.norm();
        f3.inverse();
        this.a.copy(f0);
        this.a.mul(f3);
        this.b.copy(f1);
        this.b.mul(f3);
        this.c.copy(f2);
        this.c.mul(f3);
    }

    public void frob(FP2 f) {
        FP2 f2 = new FP2(f);
        FP2 f3 = new FP2(f);
        f2.sqr();
        f3.mul(f2);
        this.a.frob(f3);
        this.b.frob(f3);
        this.c.frob(f3);
        this.b.pmul(f);
        this.c.pmul(f2);
    }

    public FP4 trace() {
        FP4 t = new FP4(0);
        t.copy(this.a);
        t.imul(3);
        t.reduce();
        return t;
    }

    public static FP12 fromBytes(byte[] w) {
        int i;
        byte[] t = new byte[32];
        for (i = 0; i < 32; ++i) {
            t[i] = w[i];
        }
        BIG a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 32];
        }
        BIG b = BIG.fromBytes(t);
        FP2 c = new FP2(a, b);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 64];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 96];
        }
        b = BIG.fromBytes(t);
        FP2 d = new FP2(a, b);
        FP4 e = new FP4(c, d);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 128];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 160];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 192];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 224];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        FP4 f = new FP4(c, d);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 256];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 288];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 320];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = w[i + 352];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        FP4 g = new FP4(c, d);
        return new FP12(e, f, g);
    }

    public void toBytes(byte[] w) {
        int i;
        byte[] t = new byte[32];
        this.a.geta().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i] = t[i];
        }
        this.a.geta().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 32] = t[i];
        }
        this.a.getb().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 64] = t[i];
        }
        this.a.getb().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 96] = t[i];
        }
        this.b.geta().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 128] = t[i];
        }
        this.b.geta().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 160] = t[i];
        }
        this.b.getb().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 192] = t[i];
        }
        this.b.getb().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 224] = t[i];
        }
        this.c.geta().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 256] = t[i];
        }
        this.c.geta().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 288] = t[i];
        }
        this.c.getb().getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 320] = t[i];
        }
        this.c.getb().getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            w[i + 352] = t[i];
        }
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "," + this.c.toString() + "]";
    }

    public FP12 pow(BIG e) {
        this.norm();
        e.norm();
        BIG e3 = new BIG(e);
        e3.pmul(3);
        e3.norm();
        FP12 w = new FP12(this);
        int nb = e3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            w.usqr();
            int bt = e3.bit(i) - e.bit(i);
            if (bt == 1) {
                w.mul(this);
            }
            if (bt != -1) continue;
            this.conj();
            w.mul(this);
            this.conj();
        }
        w.reduce();
        return w;
    }

    public void pinpow(int e, int bts) {
        FP12[] R = new FP12[]{new FP12(1), new FP12(this)};
        for (int i = bts - 1; i >= 0; --i) {
            int b = e >> i & 1;
            R[1 - b].mul(R[b]);
            R[b].usqr();
        }
        this.copy(R[0]);
    }

    public FP4 compow(BIG e, BIG r) {
        FP12 g1 = new FP12(0);
        FP12 g2 = new FP12(0);
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG q = new BIG(ROM.Modulus);
        BIG m = new BIG(q);
        m.mod(r);
        BIG a = new BIG(e);
        a.mod(m);
        BIG b = new BIG(e);
        b.div(m);
        g1.copy(this);
        g2.copy(this);
        FP4 c = g1.trace();
        if (b.iszilch()) {
            c = c.xtr_pow(e);
            return c;
        }
        g2.frob(f);
        FP4 cp = g2.trace();
        g1.conj();
        g2.mul(g1);
        FP4 cpm1 = g2.trace();
        g2.mul(g1);
        FP4 cpm2 = g2.trace();
        c = c.xtr_pow2(cp, cpm1, cpm2, a, b);
        return c;
    }

    public static FP12 pow4(FP12[] q, BIG[] u) {
        int i;
        FP12[] g = new FP12[8];
        FP12 r = new FP12(1);
        FP12 p = new FP12(0);
        BIG[] t = new BIG[4];
        BIG mt = new BIG(0);
        byte[] w = new byte[281];
        byte[] s = new byte[281];
        for (i = 0; i < 4; ++i) {
            t[i] = new BIG(u[i]);
            t[i].norm();
        }
        g[0] = new FP12(q[0]);
        g[1] = new FP12(g[0]);
        g[1].mul(q[1]);
        g[2] = new FP12(g[0]);
        g[2].mul(q[2]);
        g[3] = new FP12(g[1]);
        g[3].mul(q[2]);
        g[4] = new FP12(q[0]);
        g[4].mul(q[3]);
        g[5] = new FP12(g[1]);
        g[5].mul(q[3]);
        g[6] = new FP12(g[2]);
        g[6].mul(q[3]);
        g[7] = new FP12(g[3]);
        g[7].mul(q[3]);
        int pb = 1 - t[0].parity();
        t[0].inc(pb);
        t[0].norm();
        mt.zero();
        for (i = 0; i < 4; ++i) {
            mt.or(t[i]);
        }
        int nb = 1 + mt.nbits();
        s[nb - 1] = 1;
        for (i = 0; i < nb - 1; ++i) {
            t[0].fshr(1);
            s[i] = (byte)(2 * t[0].parity() - 1);
        }
        for (i = 0; i < nb; ++i) {
            w[i] = 0;
            int k = 1;
            for (int j = 1; j < 4; ++j) {
                byte bt = (byte)(s[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w[n] = (byte)(w[n] + bt * (byte)k);
                k *= 2;
            }
        }
        p.select(g, 2 * w[nb - 1] + 1);
        for (i = nb - 2; i >= 0; --i) {
            p.usqr();
            r.select(g, 2 * w[i] + s[i]);
            p.mul(r);
        }
        r.copy(q[0]);
        r.conj();
        r.mul(p);
        p.cmove(r, pb);
        p.reduce();
        return p;
    }
}

