/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BN254CX;

import org.apache.milagro.amcl.BN254CX.BIG;
import org.apache.milagro.amcl.BN254CX.DBIG;
import org.apache.milagro.amcl.BN254CX.ROM;

public final class FP {
    public static final int NOT_SPECIAL = 0;
    public static final int PSEUDO_MERSENNE = 1;
    public static final int MONTGOMERY_FRIENDLY = 2;
    public static final int GENERALISED_MERSENNE = 3;
    public static final int MODBITS = 254;
    public static final int MOD8 = 3;
    public static final int MODTYPE = 0;
    public static final int FEXCESS = 0x4000000;
    public static final long OMASK = -1073741824L;
    public static final int TBITS = 30;
    public static final long TMASK = 0x3FFFFFFFL;
    public final BIG x;
    public int XES;

    public static BIG mod(DBIG d) {
        return BIG.monty(new BIG(ROM.Modulus), 21990627582975621L, d);
    }

    public FP(int a) {
        this.x = new BIG(a);
        this.nres();
    }

    public FP() {
        this.x = new BIG(0);
        this.XES = 1;
    }

    public FP(BIG a) {
        this.x = new BIG(a);
        this.nres();
    }

    public FP(FP a) {
        this.x = new BIG(a.x);
        this.XES = a.XES;
    }

    public String toString() {
        String s = this.redc().toString();
        return s;
    }

    public String toRawString() {
        String s = this.x.toRawString();
        return s;
    }

    public void nres() {
        DBIG d = BIG.mul(this.x, new BIG(ROM.R2modp));
        this.x.copy(FP.mod(d));
        this.XES = 2;
    }

    public BIG redc() {
        DBIG d = new DBIG(this.x);
        return FP.mod(d);
    }

    public boolean iszilch() {
        FP z = new FP(this);
        z.reduce();
        return z.x.iszilch();
    }

    public void copy(FP b) {
        this.x.copy(b.x);
        this.XES = b.XES;
    }

    public void zero() {
        this.x.zero();
        this.XES = 1;
    }

    public void one() {
        this.x.one();
        this.nres();
    }

    public void norm() {
        this.x.norm();
    }

    public void cswap(FP b, int d) {
        this.x.cswap(b.x, d);
        int c = d;
        c = ~(c - 1);
        int t = c & (this.XES ^ b.XES);
        this.XES ^= t;
        b.XES ^= t;
    }

    public void cmove(FP b, int d) {
        this.x.cmove(b.x, d);
        this.XES ^= (this.XES ^ b.XES) & -d;
    }

    public void mul(FP b) {
        if ((long)this.XES * (long)b.XES > 0x4000000L) {
            this.reduce();
        }
        DBIG d = BIG.mul(this.x, b.x);
        this.x.copy(FP.mod(d));
        this.XES = 2;
    }

    public void imul(int c) {
        boolean s = false;
        if (c < 0) {
            c = -c;
            s = true;
        }
        if (this.XES * c <= 0x4000000) {
            this.x.pmul(c);
            this.XES *= c;
        } else {
            FP n = new FP(c);
            this.mul(n);
        }
        if (s) {
            this.neg();
            this.norm();
        }
    }

    public void sqr() {
        if ((long)this.XES * (long)this.XES > 0x4000000L) {
            this.reduce();
        }
        DBIG d = BIG.sqr(this.x);
        this.x.copy(FP.mod(d));
        this.XES = 2;
    }

    public void add(FP b) {
        this.x.add(b.x);
        this.XES += b.XES;
        if (this.XES > 0x4000000) {
            this.reduce();
        }
    }

    private static int logb2(int v) {
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        v -= v >>> 1 & 0x55555555;
        v = (v & 0x33333333) + (v >>> 2 & 0x33333333);
        int r = (v + (v >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24;
        return r;
    }

    public void neg() {
        BIG m = new BIG(ROM.Modulus);
        int sb = FP.logb2(this.XES - 1);
        m.fshl(sb);
        this.x.rsub(m);
        this.XES = 1 << sb;
        if (this.XES > 0x4000000) {
            this.reduce();
        }
    }

    public void sub(FP b) {
        FP n = new FP(b);
        n.neg();
        this.add(n);
    }

    public void rsub(FP b) {
        FP n = new FP(this);
        n.neg();
        this.copy(b);
        this.add(n);
    }

    public void div2() {
        if (this.x.parity() == 0) {
            this.x.fshr(1);
        } else {
            this.x.add(new BIG(ROM.Modulus));
            this.x.norm();
            this.x.fshr(1);
        }
    }

    public void inverse() {
        BIG m2 = new BIG(ROM.Modulus);
        m2.dec(2);
        m2.norm();
        this.copy(this.pow(m2));
    }

    public boolean equals(FP a) {
        FP f = new FP(this);
        FP s = new FP(a);
        f.reduce();
        s.reduce();
        return BIG.comp(f.x, s.x) == 0;
    }

    public void reduce() {
        this.x.mod(new BIG(ROM.Modulus));
        this.XES = 1;
    }

    public FP pow(BIG e) {
        int i;
        byte[] w = new byte[71];
        FP[] tb = new FP[16];
        BIG t = new BIG(e);
        t.norm();
        int nb = 1 + (t.nbits() + 3) / 4;
        for (i = 0; i < nb; ++i) {
            int lsbs = t.lastbits(4);
            t.dec(lsbs);
            t.norm();
            w[i] = (byte)lsbs;
            t.fshr(4);
        }
        tb[0] = new FP(1);
        tb[1] = new FP(this);
        for (i = 2; i < 16; ++i) {
            tb[i] = new FP(tb[i - 1]);
            tb[i].mul(this);
        }
        FP r = new FP(tb[w[nb - 1]]);
        for (int i2 = nb - 2; i2 >= 0; --i2) {
            r.sqr();
            r.sqr();
            r.sqr();
            r.sqr();
            r.mul(tb[w[i2]]);
        }
        r.reduce();
        return r;
    }

    public FP sqrt() {
        this.reduce();
        BIG b = new BIG(ROM.Modulus);
        b.inc(1);
        b.norm();
        b.shr(2);
        return this.pow(b);
    }

    public int jacobi() {
        BIG w = this.redc();
        return w.jacobi(new BIG(ROM.Modulus));
    }
}

