/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.C41417;

import org.apache.milagro.amcl.C41417.BIG;

public class DBIG {
    protected long[] w = new long[14];

    public void norm() {
        long carry = 0L;
        for (int i = 0; i < 13; ++i) {
            long d = this.w[i] + carry;
            carry = d >> 60;
            this.w[i] = d & 0xFFFFFFFFFFFFFFFL;
        }
        this.w[13] = this.w[13] + carry;
    }

    public BIG split(int n) {
        BIG t = new BIG(0);
        int m = n % 60;
        long carry = this.w[13] << 60 - m;
        for (int i = 12; i >= 6; --i) {
            long nw = this.w[i] >> m | carry;
            carry = this.w[i] << 60 - m & 0xFFFFFFFFFFFFFFFL;
            t.w[i - 7 + 1] = nw;
        }
        this.w[6] = this.w[6] & (1L << m) - 1L;
        return t;
    }

    public int nbits() {
        int k;
        this.norm();
        for (k = 13; this.w[k] == 0L && k >= 0; --k) {
        }
        if (k < 0) {
            return 0;
        }
        int bts = 60 * k;
        long c = this.w[k];
        while (c != 0L) {
            c /= 2L;
            ++bts;
        }
        return bts;
    }

    public String toString() {
        String s = "";
        int len = this.nbits();
        if (len % 4 == 0) {
            len >>= 2;
        } else {
            len >>= 2;
            ++len;
        }
        for (int i = len - 1; i >= 0; --i) {
            DBIG b = new DBIG(this);
            b.shr(i * 4);
            s = s + Integer.toHexString((int)(b.w[0] & 0xFL));
        }
        return s;
    }

    public void cmove(DBIG g, int d) {
        for (int i = 0; i < 14; ++i) {
            int n = i;
            this.w[n] = this.w[n] ^ (this.w[i] ^ g.w[i]) & BIG.cast_to_chunk(-d);
        }
    }

    public DBIG(int x) {
        this.w[0] = x;
        for (int i = 1; i < 14; ++i) {
            this.w[i] = 0L;
        }
    }

    public DBIG(DBIG x) {
        for (int i = 0; i < 14; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public DBIG(BIG x) {
        int i;
        for (i = 0; i < 6; ++i) {
            this.w[i] = x.w[i];
        }
        this.w[6] = x.w[6] & 0xFFFFFFFFFFFFFFFL;
        this.w[7] = x.w[6] >> 60;
        for (i = 8; i < 14; ++i) {
            this.w[i] = 0L;
        }
    }

    public void copy(DBIG x) {
        for (int i = 0; i < 14; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public void ucopy(BIG x) {
        int i;
        for (i = 0; i < 7; ++i) {
            this.w[i] = 0L;
        }
        for (i = 7; i < 14; ++i) {
            this.w[i] = x.w[i - 7];
        }
    }

    public boolean iszilch() {
        for (int i = 0; i < 14; ++i) {
            if (this.w[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public void shr(int k) {
        int i;
        int n = k % 60;
        int m = k / 60;
        for (i = 0; i < 14 - m - 1; ++i) {
            this.w[i] = this.w[m + i] >> n | this.w[m + i + 1] << 60 - n & 0xFFFFFFFFFFFFFFFL;
        }
        this.w[14 - m - 1] = this.w[13] >> n;
        for (i = 14 - m; i < 14; ++i) {
            this.w[i] = 0L;
        }
    }

    public void shl(int k) {
        int i;
        int n = k % 60;
        int m = k / 60;
        this.w[13] = this.w[13 - m] << n | this.w[14 - m - 2] >> 60 - n;
        for (i = 12; i > m; --i) {
            this.w[i] = this.w[i - m] << n & 0xFFFFFFFFFFFFFFFL | this.w[i - m - 1] >> 60 - n;
        }
        this.w[m] = this.w[0] << n & 0xFFFFFFFFFFFFFFFL;
        for (i = 0; i < m; ++i) {
            this.w[i] = 0L;
        }
    }

    public void add(DBIG x) {
        for (int i = 0; i < 14; ++i) {
            int n = i;
            this.w[n] = this.w[n] + x.w[i];
        }
    }

    public void sub(DBIG x) {
        for (int i = 0; i < 14; ++i) {
            int n = i;
            this.w[n] = this.w[n] - x.w[i];
        }
    }

    public void rsub(DBIG x) {
        for (int i = 0; i < 14; ++i) {
            this.w[i] = x.w[i] - this.w[i];
        }
    }

    public static int comp(DBIG a, DBIG b) {
        for (int i = 13; i >= 0; --i) {
            if (a.w[i] == b.w[i]) continue;
            if (a.w[i] > b.w[i]) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public BIG mod(BIG c) {
        int k = 0;
        this.norm();
        DBIG m = new DBIG(c);
        DBIG r = new DBIG(0);
        if (DBIG.comp(this, m) < 0) {
            return new BIG(this);
        }
        do {
            m.shl(1);
            ++k;
        } while (DBIG.comp(this, m) >= 0);
        while (k > 0) {
            m.shr(1);
            r.copy(this);
            r.sub(m);
            r.norm();
            this.cmove(r, (int)(1L - (r.w[13] >> 63 & 1L)));
            --k;
        }
        return new BIG(this);
    }

    public BIG div(BIG c) {
        int k = 0;
        DBIG m = new DBIG(c);
        DBIG dr = new DBIG(0);
        BIG r = new BIG(0);
        BIG a = new BIG(0);
        BIG e = new BIG(1);
        this.norm();
        while (DBIG.comp(this, m) >= 0) {
            e.fshl(1);
            m.shl(1);
            ++k;
        }
        while (k > 0) {
            m.shr(1);
            e.shr(1);
            dr.copy(this);
            dr.sub(m);
            dr.norm();
            int d = (int)(1L - (dr.w[13] >> 63 & 1L));
            this.cmove(dr, d);
            r.copy(a);
            r.add(e);
            r.norm();
            a.cmove(r, d);
            --k;
        }
        return a;
    }
}

