/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.FP256BN;

import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.FP;
import org.apache.milagro.amcl.FP256BN.FP2;

public final class FP4 {
    private final FP2 a;
    private final FP2 b;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch();
    }

    public void cmove(FP4 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
    }

    public boolean isunity() {
        FP2 one = new FP2(1);
        return this.a.equals(one) && this.b.iszilch();
    }

    public boolean isreal() {
        return this.b.iszilch();
    }

    public FP2 real() {
        return this.a;
    }

    public FP2 geta() {
        return this.a;
    }

    public FP2 getb() {
        return this.b;
    }

    public boolean equals(FP4 x) {
        return this.a.equals(x.a) && this.b.equals(x.b);
    }

    public FP4(int c) {
        this.a = new FP2(c);
        this.b = new FP2(0);
    }

    public FP4(FP4 x) {
        this.a = new FP2(x.a);
        this.b = new FP2(x.b);
    }

    public FP4(FP2 c, FP2 d) {
        this.a = new FP2(c);
        this.b = new FP2(d);
    }

    public FP4(FP2 c) {
        this.a = new FP2(c);
        this.b = new FP2(0);
    }

    public void copy(FP4 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
    }

    public void zero() {
        this.a.zero();
        this.b.zero();
    }

    public void one() {
        this.a.one();
        this.b.zero();
    }

    public void neg() {
        this.norm();
        FP2 m = new FP2(this.a);
        FP2 t = new FP2(0);
        m.add(this.b);
        m.neg();
        t.copy(m);
        t.add(this.b);
        this.b.copy(m);
        this.b.add(this.a);
        this.a.copy(t);
        this.norm();
    }

    public void conj() {
        this.b.neg();
        this.norm();
    }

    public void nconj() {
        this.a.neg();
        this.norm();
    }

    public void add(FP4 x) {
        this.a.add(x.a);
        this.b.add(x.b);
    }

    public void sub(FP4 x) {
        FP4 m = new FP4(x);
        m.neg();
        this.add(m);
    }

    public void pmul(FP2 s) {
        this.a.mul(s);
        this.b.mul(s);
    }

    public void rsub(FP4 x) {
        this.neg();
        this.add(x);
    }

    public void imul(int c) {
        this.a.imul(c);
        this.b.imul(c);
    }

    public void sqr() {
        FP2 t1 = new FP2(this.a);
        FP2 t2 = new FP2(this.b);
        FP2 t3 = new FP2(this.a);
        t3.mul(this.b);
        t1.add(this.b);
        t2.mul_ip();
        t2.add(this.a);
        t1.norm();
        t2.norm();
        this.a.copy(t1);
        this.a.mul(t2);
        t2.copy(t3);
        t2.mul_ip();
        t2.add(t3);
        t2.norm();
        t2.neg();
        this.a.add(t2);
        this.b.copy(t3);
        this.b.add(t3);
        this.norm();
    }

    public void mul(FP4 y) {
        FP2 t1 = new FP2(this.a);
        FP2 t2 = new FP2(this.b);
        FP2 t3 = new FP2(0);
        FP2 t4 = new FP2(this.b);
        t1.mul(y.a);
        t2.mul(y.b);
        t3.copy(y.b);
        t3.add(y.a);
        t4.add(this.a);
        t3.norm();
        t4.norm();
        t4.mul(t3);
        t3.copy(t1);
        t3.neg();
        t4.add(t3);
        t4.norm();
        t3.copy(t2);
        t3.neg();
        this.b.copy(t4);
        this.b.add(t3);
        t2.mul_ip();
        this.a.copy(t2);
        this.a.add(t1);
        this.norm();
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "]";
    }

    public String toRawString() {
        return "[" + this.a.toRawString() + "," + this.b.toRawString() + "]";
    }

    public void inverse() {
        FP2 t1 = new FP2(this.a);
        FP2 t2 = new FP2(this.b);
        t1.sqr();
        t2.sqr();
        t2.mul_ip();
        t2.norm();
        t1.sub(t2);
        t1.inverse();
        this.a.mul(t1);
        t1.neg();
        t1.norm();
        this.b.mul(t1);
    }

    public void times_i() {
        FP2 s = new FP2(this.b);
        FP2 t = new FP2(this.b);
        s.times_i();
        t.add(s);
        this.b.copy(this.a);
        this.a.copy(t);
        this.norm();
    }

    public void frob(FP2 f) {
        this.a.conj();
        this.b.conj();
        this.b.mul(f);
    }

    public FP4 pow(BIG e) {
        this.norm();
        e.norm();
        FP4 w = new FP4(this);
        BIG z = new BIG(e);
        FP4 r = new FP4(1);
        while (true) {
            int bt = z.parity();
            z.fshr(1);
            if (bt == 1) {
                r.mul(w);
            }
            if (z.iszilch()) break;
            w.sqr();
        }
        r.reduce();
        return r;
    }

    public void xtr_A(FP4 w, FP4 y, FP4 z) {
        FP4 r = new FP4(w);
        FP4 t = new FP4(w);
        r.sub(y);
        r.norm();
        r.pmul(this.a);
        t.add(y);
        t.norm();
        t.pmul(this.b);
        t.times_i();
        this.copy(r);
        this.add(t);
        this.add(z);
        this.norm();
    }

    public void xtr_D() {
        FP4 w = new FP4(this);
        this.sqr();
        w.conj();
        w.add(w);
        w.norm();
        this.sub(w);
        this.reduce();
    }

    public FP4 xtr_pow(BIG n) {
        FP4 a = new FP4(3);
        FP4 b = new FP4(this);
        FP4 c = new FP4(b);
        c.xtr_D();
        FP4 t = new FP4(0);
        FP4 r = new FP4(0);
        n.norm();
        int par = n.parity();
        BIG v = new BIG(n);
        v.fshr(1);
        if (par == 0) {
            v.dec(1);
            v.norm();
        }
        int nb = v.nbits();
        for (int i = nb - 1; i >= 0; --i) {
            if (v.bit(i) != 1) {
                t.copy(b);
                this.conj();
                c.conj();
                b.xtr_A(a, this, c);
                this.conj();
                c.copy(t);
                c.xtr_D();
                a.xtr_D();
                continue;
            }
            t.copy(a);
            t.conj();
            a.copy(b);
            a.xtr_D();
            b.xtr_A(c, this, t);
            c.xtr_D();
        }
        if (par == 0) {
            r.copy(c);
        } else {
            r.copy(b);
        }
        r.reduce();
        return r;
    }

    public FP4 xtr_pow2(FP4 ck, FP4 ckml, FP4 ckm2l, BIG a, BIG b) {
        a.norm();
        b.norm();
        BIG e = new BIG(a);
        BIG d = new BIG(b);
        BIG w = new BIG(0);
        FP4 cu = new FP4(ck);
        FP4 cv = new FP4(this);
        FP4 cumv = new FP4(ckml);
        FP4 cum2v = new FP4(ckm2l);
        FP4 r = new FP4(0);
        FP4 t = new FP4(0);
        int f2 = 0;
        while (d.parity() == 0 && e.parity() == 0) {
            d.fshr(1);
            e.fshr(1);
            ++f2;
        }
        while (BIG.comp(d, e) != 0) {
            if (BIG.comp(d, e) > 0) {
                w.copy(e);
                w.imul(4);
                w.norm();
                if (BIG.comp(d, w) <= 0) {
                    w.copy(d);
                    d.copy(e);
                    e.rsub(w);
                    e.norm();
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cum2v.copy(cumv);
                    cum2v.conj();
                    cumv.copy(cv);
                    cv.copy(cu);
                    cu.copy(t);
                } else if (d.parity() == 0) {
                    d.fshr(1);
                    r.copy(cum2v);
                    r.conj();
                    t.copy(cumv);
                    t.xtr_A(cu, cv, r);
                    cum2v.copy(cumv);
                    cum2v.xtr_D();
                    cumv.copy(t);
                    cu.xtr_D();
                } else if (e.parity() == 1) {
                    d.sub(e);
                    d.norm();
                    d.fshr(1);
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cu.xtr_D();
                    cum2v.copy(cv);
                    cum2v.xtr_D();
                    cum2v.conj();
                    cv.copy(t);
                } else {
                    w.copy(d);
                    d.copy(e);
                    d.fshr(1);
                    e.copy(w);
                    t.copy(cumv);
                    t.xtr_D();
                    cumv.copy(cum2v);
                    cumv.conj();
                    cum2v.copy(t);
                    cum2v.conj();
                    t.copy(cv);
                    t.xtr_D();
                    cv.copy(cu);
                    cu.copy(t);
                }
            }
            if (BIG.comp(d, e) >= 0) continue;
            w.copy(d);
            w.imul(4);
            w.norm();
            if (BIG.comp(e, w) <= 0) {
                e.sub(d);
                e.norm();
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cum2v.copy(cumv);
                cumv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (e.parity() == 0) {
                w.copy(d);
                d.copy(e);
                d.fshr(1);
                e.copy(w);
                t.copy(cumv);
                t.xtr_D();
                cumv.copy(cum2v);
                cumv.conj();
                cum2v.copy(t);
                cum2v.conj();
                t.copy(cv);
                t.xtr_D();
                cv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (d.parity() == 1) {
                w.copy(e);
                e.copy(d);
                w.sub(d);
                w.norm();
                d.copy(w);
                d.fshr(1);
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cumv.conj();
                cum2v.copy(cu);
                cum2v.xtr_D();
                cum2v.conj();
                cu.copy(cv);
                cu.xtr_D();
                cv.copy(t);
                continue;
            }
            d.fshr(1);
            r.copy(cum2v);
            r.conj();
            t.copy(cumv);
            t.xtr_A(cu, cv, r);
            cum2v.copy(cumv);
            cum2v.xtr_D();
            cumv.copy(t);
            cu.xtr_D();
        }
        r.copy(cv);
        r.xtr_A(cu, cumv, cum2v);
        for (int i = 0; i < f2; ++i) {
            r.xtr_D();
        }
        r = r.xtr_pow(d);
        return r;
    }

    public void div2() {
        this.a.div2();
        this.b.div2();
    }

    public void div_i() {
        FP2 u = new FP2(this.a);
        FP2 v = new FP2(this.b);
        u.div_ip();
        this.a.copy(v);
        this.b.copy(u);
    }

    public void div_2i() {
        FP2 u = new FP2(this.a);
        FP2 v = new FP2(this.b);
        u.div_ip2();
        v.add(v);
        v.norm();
        this.a.copy(v);
        this.b.copy(u);
    }

    public boolean sqrt() {
        if (this.iszilch()) {
            return true;
        }
        FP2 wa = new FP2(this.a);
        FP2 ws = new FP2(this.b);
        FP2 wt = new FP2(this.a);
        if (ws.iszilch()) {
            if (wt.sqrt()) {
                this.a.copy(wt);
                this.b.zero();
            } else {
                wt.div_ip();
                wt.sqrt();
                this.b.copy(wt);
                this.a.zero();
            }
            return true;
        }
        ws.sqr();
        wa.sqr();
        ws.mul_ip();
        ws.norm();
        wa.sub(ws);
        ws.copy(wa);
        if (!ws.sqrt()) {
            return false;
        }
        wa.copy(wt);
        wa.add(ws);
        wa.norm();
        wa.div2();
        if (!wa.sqrt()) {
            wa.copy(wt);
            wa.sub(ws);
            wa.norm();
            wa.div2();
            if (!wa.sqrt()) {
                return false;
            }
        }
        wt.copy(this.b);
        ws.copy(wa);
        ws.add(wa);
        ws.inverse();
        wt.mul(ws);
        this.a.copy(wa);
        this.b.copy(wt);
        return true;
    }

    public void qmul(FP s) {
        this.a.pmul(s);
        this.b.pmul(s);
    }
}

