/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.RSA4096;

import org.apache.milagro.amcl.HASH256;
import org.apache.milagro.amcl.HASH384;
import org.apache.milagro.amcl.HASH512;
import org.apache.milagro.amcl.RAND;
import org.apache.milagro.amcl.RSA4096.FF;
import org.apache.milagro.amcl.RSA4096.private_key;
import org.apache.milagro.amcl.RSA4096.public_key;

public final class RSA {
    public static final int RFS = 512;
    public static final int SHA256 = 32;
    public static final int SHA384 = 48;
    public static final int SHA512 = 64;
    public static final int HASH_TYPE = 32;
    private static final byte[] SHA256ID = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SHA384ID = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static final byte[] SHA512ID = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};

    public static byte[] hashit(int sha, byte[] A, int n) {
        Object H;
        byte[] R = null;
        if (sha == 32) {
            H = new HASH256();
            if (A != null) {
                ((HASH256)H).process_array(A);
            }
            if (n >= 0) {
                ((HASH256)H).process_num(n);
            }
            R = ((HASH256)H).hash();
        }
        if (sha == 48) {
            H = new HASH384();
            if (A != null) {
                ((HASH384)H).process_array(A);
            }
            if (n >= 0) {
                ((HASH384)H).process_num(n);
            }
            R = ((HASH384)H).hash();
        }
        if (sha == 64) {
            H = new HASH512();
            if (A != null) {
                ((HASH512)H).process_array(A);
            }
            if (n >= 0) {
                ((HASH512)H).process_num(n);
            }
            R = ((HASH512)H).hash();
        }
        return R;
    }

    public static void KEY_PAIR(RAND rng, int e, private_key PRIV, public_key PUB) {
        int n = PUB.n.getlen() / 2;
        FF t = new FF(n);
        FF p1 = new FF(n);
        FF q1 = new FF(n);
        do {
            PRIV.p.random(rng);
            while (PRIV.p.lastbits(2) != 3) {
                PRIV.p.inc(1);
            }
            while (!FF.prime(PRIV.p, rng)) {
                PRIV.p.inc(4);
            }
            p1.copy(PRIV.p);
            p1.dec(1);
        } while (p1.cfactor(e));
        do {
            PRIV.q.random(rng);
            while (PRIV.q.lastbits(2) != 3) {
                PRIV.q.inc(1);
            }
            while (!FF.prime(PRIV.q, rng)) {
                PRIV.q.inc(4);
            }
            q1.copy(PRIV.q);
            q1.dec(1);
        } while (q1.cfactor(e));
        PUB.n = FF.mul(PRIV.p, PRIV.q);
        PUB.e = e;
        t.copy(p1);
        t.shr();
        PRIV.dp.set(e);
        PRIV.dp.invmodp(t);
        if (PRIV.dp.parity() == 0) {
            PRIV.dp.add(t);
        }
        PRIV.dp.norm();
        t.copy(q1);
        t.shr();
        PRIV.dq.set(e);
        PRIV.dq.invmodp(t);
        if (PRIV.dq.parity() == 0) {
            PRIV.dq.add(t);
        }
        PRIV.dq.norm();
        PRIV.c.copy(PRIV.p);
        PRIV.c.invmodp(PRIV.q);
    }

    public static void MGF1(int sha, byte[] Z, int olen, byte[] K) {
        int i;
        int hlen = sha;
        int k = 0;
        for (i = 0; i < K.length; ++i) {
            K[i] = 0;
        }
        int cthreshold = olen / hlen;
        if (olen % hlen != 0) {
            ++cthreshold;
        }
        for (int counter = 0; counter < cthreshold; ++counter) {
            byte[] B = RSA.hashit(sha, Z, counter);
            if (k + hlen > olen) {
                for (i = 0; i < olen % hlen; ++i) {
                    K[k++] = B[i];
                }
                continue;
            }
            for (i = 0; i < hlen; ++i) {
                K[k++] = B[i];
            }
        }
    }

    public static void printBinary(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.printf("%02x", array[i]);
        }
        System.out.println();
    }

    public static boolean PKCS15(int sha, byte[] m, byte[] w) {
        int j;
        int i;
        int olen = 512;
        int idlen = 19;
        int hlen = sha;
        if (olen < idlen + hlen + 10) {
            return false;
        }
        byte[] H = RSA.hashit(sha, m, -1);
        for (i = 0; i < w.length; ++i) {
            w[i] = 0;
        }
        i = 0;
        w[i++] = 0;
        w[i++] = 1;
        for (j = 0; j < olen - idlen - hlen - 3; ++j) {
            w[i++] = -1;
        }
        w[i++] = 0;
        if (hlen == 32) {
            for (j = 0; j < idlen; ++j) {
                w[i++] = SHA256ID[j];
            }
        }
        if (hlen == 48) {
            for (j = 0; j < idlen; ++j) {
                w[i++] = SHA384ID[j];
            }
        }
        if (hlen == 64) {
            for (j = 0; j < idlen; ++j) {
                w[i++] = SHA512ID[j];
            }
        }
        for (j = 0; j < hlen; ++j) {
            w[i++] = H[j];
        }
        return true;
    }

    public static byte[] OAEP_ENCODE(int sha, byte[] m, RAND rng, byte[] p) {
        int i;
        int olen = 511;
        int mlen = m.length;
        byte[] f = new byte[512];
        int hlen = sha;
        byte[] SEED = new byte[hlen];
        int seedlen = hlen;
        if (mlen > olen - hlen - seedlen - 1) {
            return new byte[0];
        }
        byte[] DBMASK = new byte[olen - seedlen];
        byte[] h = RSA.hashit(sha, p, -1);
        for (i = 0; i < hlen; ++i) {
            f[i] = h[i];
        }
        int slen = olen - mlen - hlen - seedlen - 1;
        for (i = 0; i < slen; ++i) {
            f[hlen + i] = 0;
        }
        f[hlen + slen] = 1;
        for (i = 0; i < mlen; ++i) {
            f[hlen + slen + 1 + i] = m[i];
        }
        for (i = 0; i < seedlen; ++i) {
            SEED[i] = (byte)rng.getByte();
        }
        RSA.MGF1(sha, SEED, olen - seedlen, DBMASK);
        for (i = 0; i < olen - seedlen; ++i) {
            int n = i;
            DBMASK[n] = (byte)(DBMASK[n] ^ f[i]);
        }
        RSA.MGF1(sha, DBMASK, seedlen, f);
        for (i = 0; i < seedlen; ++i) {
            int n = i;
            f[n] = (byte)(f[n] ^ SEED[i]);
        }
        for (i = 0; i < olen - seedlen; ++i) {
            f[i + seedlen] = DBMASK[i];
        }
        int d = 1;
        for (i = 511; i >= d; --i) {
            f[i] = f[i - d];
        }
        for (i = d - 1; i >= 0; --i) {
            f[i] = 0;
        }
        return f;
    }

    public static byte[] OAEP_DECODE(int sha, byte[] p, byte[] f) {
        int i;
        int olen = 511;
        int hlen = sha;
        byte[] SEED = new byte[hlen];
        int seedlen = hlen;
        byte[] CHASH = new byte[hlen];
        if (olen < seedlen + hlen + 1) {
            return new byte[0];
        }
        byte[] DBMASK = new byte[olen - seedlen];
        for (i = 0; i < olen - seedlen; ++i) {
            DBMASK[i] = 0;
        }
        if (f.length < 512) {
            int d = 512 - f.length;
            for (i = 511; i >= d; --i) {
                f[i] = f[i - d];
            }
            for (i = d - 1; i >= 0; --i) {
                f[i] = 0;
            }
        }
        byte[] h = RSA.hashit(sha, p, -1);
        for (i = 0; i < hlen; ++i) {
            CHASH[i] = h[i];
        }
        byte x = f[0];
        for (i = seedlen; i < olen; ++i) {
            DBMASK[i - seedlen] = f[i + 1];
        }
        RSA.MGF1(sha, DBMASK, seedlen, SEED);
        for (i = 0; i < seedlen; ++i) {
            int n = i;
            SEED[n] = (byte)(SEED[n] ^ f[i + 1]);
        }
        RSA.MGF1(sha, SEED, olen - seedlen, f);
        for (i = 0; i < olen - seedlen; ++i) {
            int n = i;
            DBMASK[n] = (byte)(DBMASK[n] ^ f[i]);
        }
        boolean comp = true;
        for (i = 0; i < hlen; ++i) {
            if (CHASH[i] == DBMASK[i]) continue;
            comp = false;
        }
        for (i = 0; i < olen - seedlen - hlen; ++i) {
            DBMASK[i] = DBMASK[i + hlen];
        }
        for (i = 0; i < hlen; ++i) {
            CHASH[i] = 0;
            SEED[i] = 0;
        }
        int k = 0;
        while (true) {
            if (k >= olen - seedlen - hlen) {
                return new byte[0];
            }
            if (DBMASK[k] != 0) break;
            ++k;
        }
        byte t = DBMASK[k];
        if (!comp || x != 0 || t != 1) {
            for (i = 0; i < olen - seedlen; ++i) {
                DBMASK[i] = 0;
            }
            return new byte[0];
        }
        byte[] r = new byte[olen - seedlen - hlen - k - 1];
        for (i = 0; i < olen - seedlen - hlen - k - 1; ++i) {
            r[i] = DBMASK[i + k + 1];
        }
        for (i = 0; i < olen - seedlen; ++i) {
            DBMASK[i] = 0;
        }
        return r;
    }

    public static void PRIVATE_KEY_KILL(private_key PRIV) {
        PRIV.p.zero();
        PRIV.q.zero();
        PRIV.dp.zero();
        PRIV.dq.zero();
        PRIV.c.zero();
    }

    public static void ENCRYPT(public_key PUB, byte[] F, byte[] G) {
        int n = PUB.n.getlen();
        FF f = new FF(n);
        FF.fromBytes(f, F);
        f.power(PUB.e, PUB.n);
        f.toBytes(G);
    }

    public static void DECRYPT(private_key PRIV, byte[] G, byte[] F) {
        int n = PRIV.p.getlen();
        FF g = new FF(2 * n);
        FF.fromBytes(g, G);
        FF jp = g.dmod(PRIV.p);
        FF jq = g.dmod(PRIV.q);
        jp.skpow(PRIV.dp, PRIV.p);
        jq.skpow(PRIV.dq, PRIV.q);
        g.zero();
        g.dscopy(jp);
        jp.mod(PRIV.q);
        if (FF.comp(jp, jq) > 0) {
            jq.add(PRIV.q);
        }
        jq.sub(jp);
        jq.norm();
        FF t = FF.mul(PRIV.c, jq);
        jq = t.dmod(PRIV.q);
        t = FF.mul(jq, PRIV.p);
        g.add(t);
        g.norm();
        g.toBytes(F);
    }
}

