/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mitre.caasd.commons.DataCleaner;
import org.mitre.caasd.commons.util.DemotedException;

public class CachingCleaner<T>
implements DataCleaner<T> {
    private final DataCleaner<T> cleaner;
    private final LoadingCache<T, Optional<T>> cache;

    public CachingCleaner(DataCleaner<T> cleaner, int cacheSize) {
        this(cleaner, CachingCleaner.makeCacheFor(cleaner, cacheSize));
    }

    public CachingCleaner(DataCleaner<T> cleaner, int cacheSize, Duration expiration) {
        this(cleaner, CachingCleaner.makeExpiringCacheFor(cleaner, cacheSize, expiration));
    }

    public CachingCleaner(DataCleaner<T> cleaner, LoadingCache<T, Optional<T>> cache) {
        this.cleaner = (DataCleaner)Preconditions.checkNotNull(cleaner);
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache);
    }

    public DataCleaner<T> cleaner() {
        return this.cleaner;
    }

    public Cache<T, Optional<T>> cache() {
        return this.cache;
    }

    @Override
    public Optional<T> clean(T data) {
        try {
            return (Optional)this.cache.get(data);
        }
        catch (ExecutionException ex) {
            throw DemotedException.demote(ex);
        }
    }

    private static <T> LoadingCache<T, Optional<T>> makeCacheFor(DataCleaner<T> cleaner, int cacheSize) {
        return CacheBuilder.newBuilder().maximumSize((long)cacheSize).recordStats().build(CachingCleaner.makeCacheLoaderFrom(cleaner));
    }

    private static <T> LoadingCache<T, Optional<T>> makeExpiringCacheFor(DataCleaner<T> cleaner, int cacheSize, Duration expiration) {
        return CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterAccess(expiration.toMillis(), TimeUnit.MILLISECONDS).recordStats().build(CachingCleaner.makeCacheLoaderFrom(cleaner));
    }

    public static <T> CacheLoader<T, Optional<T>> makeCacheLoaderFrom(final DataCleaner<T> cleaner) {
        return new CacheLoader<T, Optional<T>>(){

            public Optional<T> load(T item) throws Exception {
                return cleaner.clean(item);
            }
        };
    }
}

