/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.mitre.caasd.commons.util.Preconditions;

public class CombinedPredicate<T>
implements Predicate<T> {
    private final List<Predicate<T>> components;
    private final Predicate<T> combination;

    @SafeVarargs
    public CombinedPredicate(Predicate<T> ... requirements) {
        Preconditions.checkNoNullElement(requirements);
        this.components = Lists.newArrayList((Object[])requirements);
        this.combination = CombinedPredicate.combine(requirements);
    }

    @Override
    public boolean test(T t) {
        return this.combination.test(t);
    }

    public List<Predicate<T>> components() {
        return Collections.unmodifiableList(this.components);
    }

    @SafeVarargs
    public static <T> Predicate<T> combine(Predicate<T> ... predicates) {
        com.google.common.base.Preconditions.checkNotNull(predicates);
        com.google.common.base.Preconditions.checkArgument((predicates.length > 0 ? 1 : 0) != 0);
        Predicate<T> workingPred = predicates[0];
        for (int i = 1; i < predicates.length; ++i) {
            workingPred = workingPred.and(predicates[i]);
        }
        return workingPred;
    }
}

