/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.mitre.caasd.commons.DataCleaner;

public class CompositeCleaner<T>
implements DataCleaner<T> {
    private final List<DataCleaner<? super T>> cleaners;

    public CompositeCleaner(List<DataCleaner<? super T>> cleaners) {
        this.cleaners = Lists.newArrayList(cleaners);
    }

    @SafeVarargs
    public static <T> CompositeCleaner<T> of(DataCleaner<? super T> ... cleaners) {
        return new CompositeCleaner<T>(Lists.newArrayList((Object[])cleaners));
    }

    @Override
    public Optional<T> clean(T dataItem) {
        if (this.cleaners.isEmpty()) {
            return Optional.of(dataItem);
        }
        T current = dataItem;
        Optional<T> lastResult = null;
        for (DataCleaner<T> smoother : this.cleaners) {
            lastResult = smoother.clean(current);
            if (lastResult.isPresent()) {
                current = lastResult.get();
                continue;
            }
            return Optional.empty();
        }
        return lastResult;
    }
}

