/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.io.Serializable;
import java.util.function.Consumer;

public class CountingConsumer<T>
implements Consumer<T>,
Serializable {
    private static final long serialVersionUID = 7876428916387834743L;
    private int numCallsToAccept = 0;
    private final Consumer<T> wrappedConsumer;

    public CountingConsumer(Consumer<T> consumer) {
        this.wrappedConsumer = consumer;
    }

    @Override
    public void accept(T t) {
        ++this.numCallsToAccept;
        this.wrappedConsumer.accept(t);
    }

    public int numCallsToAccept() {
        return this.numCallsToAccept;
    }

    public Consumer<T> innerConsumer() {
        return this.wrappedConsumer;
    }
}

