/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;

public class CountingPredicate<T>
implements Predicate<T> {
    private final Predicate<T> predicate;
    private long numCalls;
    private long numTrue;
    private long numFalse;

    public CountingPredicate(Predicate<T> pred) {
        Preconditions.checkNotNull(pred);
        this.predicate = pred;
    }

    public static <T> CountingPredicate<T> from(Predicate<T> predicate) {
        return new CountingPredicate<T>(predicate);
    }

    @Override
    public boolean test(T t) {
        ++this.numCalls;
        boolean result = this.predicate.test(t);
        if (result) {
            ++this.numTrue;
        } else {
            ++this.numFalse;
        }
        return result;
    }

    public void resetCounts() {
        this.numCalls = 0L;
        this.numTrue = 0L;
        this.numFalse = 0L;
    }

    public long count() {
        return this.numCalls;
    }

    public long trueCount() {
        return this.numTrue;
    }

    public long falseCount() {
        return this.numFalse;
    }
}

