/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mitre.caasd.commons.DataCleaner;
import org.mitre.caasd.commons.Functions;

public class DataFilter<T>
implements DataCleaner<T> {
    private final Predicate<T> filter;
    private final Consumer<T> onRemoval;

    public DataFilter(Predicate<T> filter) {
        this(filter, Functions.NO_OP_CONSUMER);
    }

    public DataFilter(Predicate<T> filter, Consumer<T> onRemoval) {
        this.filter = (Predicate)Preconditions.checkNotNull(filter);
        this.onRemoval = (Consumer)Preconditions.checkNotNull(onRemoval);
    }

    @Override
    public Optional<T> clean(T input) {
        boolean filterAccepts = this.filter.test(input);
        if (!filterAccepts) {
            this.onRemoval.accept(input);
        }
        return filterAccepts ? Optional.of(input) : Optional.empty();
    }
}

