/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mitre.caasd.commons.DataCleaner;
import org.mitre.caasd.commons.Functions;
import org.mitre.caasd.commons.util.ExceptionHandler;
import org.mitre.caasd.commons.util.SequentialFileWriter;

public class ExceptionCatchingCleaner<T>
implements DataCleaner<T> {
    private final DataCleaner<T> cleaner;
    private final Functions.ToStringFunction<T> messageMaker;
    private final ExceptionHandler errorHandler;

    public ExceptionCatchingCleaner(DataCleaner<T> cleaner, Functions.ToStringFunction<T> toString, ExceptionHandler errorHandler) {
        this.cleaner = (DataCleaner)Preconditions.checkNotNull(cleaner);
        this.messageMaker = (Functions.ToStringFunction)Preconditions.checkNotNull(toString);
        this.errorHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)errorHandler);
    }

    public ExceptionCatchingCleaner(DataCleaner<T> cleaner) {
        this(cleaner, item -> item.toString(), new SequentialFileWriter("caughtInDataCleaning"));
    }

    @Override
    public Optional<T> clean(T data) {
        try {
            return this.cleaner.clean(data);
        }
        catch (Exception ex) {
            String message = (String)this.messageMaker.apply(data);
            this.errorHandler.handle(message, ex);
            return Optional.empty();
        }
    }
}

