/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.mitre.caasd.commons.Course;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.Spherical;

public interface HasPosition {
    public LatLong latLong();

    default public double latitude() {
        return this.latLong().latitude();
    }

    default public double longitude() {
        return this.latLong().longitude();
    }

    default public double distanceInNmTo(HasPosition other) {
        Preconditions.checkNotNull((Object)other, (Object)"Cannot compute the distance to a null HasPosition object");
        return this.latLong().distanceInNM(other.latLong());
    }

    default public double courseInDegrees(HasPosition that) {
        return Spherical.courseInDegrees(this.latitude(), this.longitude(), that.latitude(), that.longitude());
    }

    default public Course courseTo(HasPosition that) {
        return Course.ofDegrees(this.courseInDegrees(that));
    }

    default public HasPosition projectOut(Double course, Double distance) {
        return () -> Spherical.projectOut(this.latitude(), this.longitude(), course, distance);
    }

    default public double distanceInRadians(HasPosition that) {
        return Spherical.distanceInRadians(this.distanceInNmTo(that));
    }

    public static Double maxLatitude(Collection<? extends HasPosition> locations) {
        HasPosition.checkInput(locations);
        return locations.stream().map(hasPosition -> hasPosition.latitude()).reduce(-1.7976931348623157E308, Math::max);
    }

    public static Double minLatitude(Collection<? extends HasPosition> locations) {
        HasPosition.checkInput(locations);
        return locations.stream().map(hasPosition -> hasPosition.latitude()).reduce((Double)Double.MAX_VALUE, Math::min);
    }

    public static Double maxLongitude(Collection<? extends HasPosition> locations) {
        HasPosition.checkInput(locations);
        return locations.stream().map(hasPosition -> hasPosition.longitude()).reduce(-1.7976931348623157E308, Math::max);
    }

    public static Double minLongitude(Collection<? extends HasPosition> locations) {
        HasPosition.checkInput(locations);
        return locations.stream().map(hasPosition -> hasPosition.longitude()).reduce((Double)Double.MAX_VALUE, Math::min);
    }

    public static void checkInput(Collection<? extends HasPosition> locations) {
        Preconditions.checkNotNull(locations, (Object)"The Collection of HasPositions cannot be null");
        Preconditions.checkArgument((!locations.isEmpty() ? 1 : 0) != 0, (Object)"The Collection of HasPositions cannot be empty");
    }

    public static HasPosition from(Double lat, Double lon) {
        return () -> new LatLong(lat, lon);
    }

    public static HasPosition from(LatLong location) {
        return () -> location;
    }
}

