/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.mitre.caasd.commons.CollectionUtils;
import org.mitre.caasd.commons.Time;
import org.mitre.caasd.commons.TimeWindow;

@FunctionalInterface
public interface HasTime {
    public Instant time();

    default public long timeAsEpochMs() {
        return this.time().toEpochMilli();
    }

    public static void validate(Instant time) {
        Preconditions.checkState((boolean)Objects.nonNull(time), (Object)"time() cannot return null");
        Preconditions.checkState((time.toEpochMilli() > 0L ? 1 : 0) != 0, (Object)"time() must return positive epochMilli");
    }

    default public Duration durationBtw(Instant time) {
        return Duration.between(this.time(), time).abs();
    }

    default public Duration durationBtw(HasTime hasTime) {
        return this.durationBtw(hasTime.time());
    }

    public static HasTime wrap(Long epochMills) {
        return () -> Instant.ofEpochMilli(epochMills);
    }

    public static HasTime wrap(Instant time) {
        return () -> time;
    }

    public static <P extends HasTime> P nearest(P left, P right, Instant time) {
        Duration leftDelta = Duration.between(left.time(), time).abs();
        Duration rightDelta = Duration.between(right.time(), time).abs();
        return Time.theDuration(leftDelta).isLessThanOrEqualTo(rightDelta) ? left : right;
    }

    public static <T extends HasTime> int binarySearch(List<? extends T> itemsSortedByTime, Instant searchTime) {
        Objects.requireNonNull(itemsSortedByTime);
        Objects.requireNonNull(searchTime);
        return CollectionUtils.binarySearch(itemsSortedByTime, HasTime::time, searchTime);
    }

    public static <T extends HasTime> T floor(List<? extends T> itemsSortedByTime, Instant searchTime) {
        Objects.requireNonNull(itemsSortedByTime);
        Objects.requireNonNull(searchTime);
        Instant start = ((HasTime)itemsSortedByTime.get(0)).time();
        Instant end = ((HasTime)itemsSortedByTime.get(itemsSortedByTime.size() - 1)).time();
        TimeWindow window = TimeWindow.of(start, end);
        Preconditions.checkArgument((boolean)window.contains(searchTime), (Object)"searchTime must be inside spanning TimeWindow");
        int index = HasTime.binarySearch(itemsSortedByTime, searchTime);
        return (T)(index >= 0 ? (HasTime)itemsSortedByTime.get(index) : (HasTime)itemsSortedByTime.get(-index - 2));
    }

    public static <T extends HasTime> T ceiling(List<? extends T> itemsSortedByTime, Instant searchTime) {
        Objects.requireNonNull(itemsSortedByTime);
        Objects.requireNonNull(searchTime);
        Instant start = ((HasTime)itemsSortedByTime.get(0)).time();
        Instant end = ((HasTime)itemsSortedByTime.get(itemsSortedByTime.size() - 1)).time();
        TimeWindow window = TimeWindow.of(start, end);
        Preconditions.checkArgument((boolean)window.contains(searchTime), (Object)"searchTime must be inside spanning TimeWindow");
        int index = HasTime.binarySearch(itemsSortedByTime, searchTime);
        return (T)(index >= 0 ? (HasTime)itemsSortedByTime.get(index) : (HasTime)itemsSortedByTime.get(-index - 1));
    }

    public static <T extends HasTime> T closest(List<? extends T> itemsSortedByTime, Instant searchTime) {
        Objects.requireNonNull(itemsSortedByTime);
        Objects.requireNonNull(searchTime);
        Instant start = ((HasTime)itemsSortedByTime.get(0)).time();
        Instant end = ((HasTime)itemsSortedByTime.get(itemsSortedByTime.size() - 1)).time();
        TimeWindow window = TimeWindow.of(start, end);
        Preconditions.checkArgument((boolean)window.contains(searchTime), (Object)"searchTime must be inside spanning TimeWindow");
        int index = HasTime.binarySearch(itemsSortedByTime, searchTime);
        if (index >= 0) {
            return (T)((HasTime)itemsSortedByTime.get(index));
        }
        int floorIndex = -index - 2;
        int ceilIndex = -index - 1;
        HasTime floor = (HasTime)itemsSortedByTime.get(floorIndex);
        HasTime ceil = (HasTime)itemsSortedByTime.get(ceilIndex);
        Duration floorDelta = Duration.between(floor.time(), searchTime);
        Duration ceilDelta = Duration.between(searchTime, ceil.time());
        if (Time.theDuration(floorDelta).isLessThanOrEqualTo(ceilDelta)) {
            return (T)floor;
        }
        return (T)ceil;
    }
}

