/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mitre.caasd.commons.TimeWindow;

public class InstantIterator
implements Iterator<Instant> {
    private final TimeWindow window;
    private final Duration timeStep;
    private Instant next;

    public InstantIterator(Instant startTime, Instant endTime, Duration timeStep) {
        Preconditions.checkNotNull((Object)startTime, (Object)"The start time cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"The end time cannot be null");
        Preconditions.checkNotNull((Object)timeStep, (Object)"The timeStep cannot be null");
        Preconditions.checkArgument((!timeStep.isNegative() ? 1 : 0) != 0, (Object)"The timeStep cannot be negative");
        Preconditions.checkArgument((!timeStep.isZero() ? 1 : 0) != 0, (Object)"The timeStep cannot be zero");
        this.window = new TimeWindow(startTime, endTime);
        this.timeStep = timeStep;
        this.next = this.window.start();
    }

    public InstantIterator(TimeWindow window, Duration timeStep) {
        this(window.start(), window.end(), timeStep);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Instant next() {
        if (this.hasNext()) {
            Instant returnMe = this.next;
            this.updateNext();
            return returnMe;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        Instant possible;
        this.next = this.next.equals(this.window.end()) ? null : (this.window.contains(possible = this.next.plus(this.timeStep)) ? possible : this.window.end());
    }
}

