/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.time.Instant;
import java.util.Objects;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.HasPosition;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.KineticPosition;
import org.mitre.caasd.commons.LatLong;

public class KineticRecord<T>
implements HasTime,
HasPosition {
    private final T datum;
    private final KineticPosition position;

    public KineticRecord(T item, KineticPosition position) {
        Objects.requireNonNull(item);
        Objects.requireNonNull(position);
        this.datum = item;
        this.position = position;
    }

    private KineticRecord() {
        this.datum = null;
        this.position = null;
    }

    public T datum() {
        return this.datum;
    }

    public KineticPosition kinetics() {
        return this.position;
    }

    @Override
    public Instant time() {
        return this.kinetics().time();
    }

    @Override
    public LatLong latLong() {
        return this.kinetics().latLong();
    }

    public Distance altitude() {
        return this.kinetics().altitude();
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.datum);
        hash = 29 * hash + Objects.hashCode(this.position);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KineticRecord other = (KineticRecord)obj;
        if (!Objects.equals(this.datum, other.datum)) {
            return false;
        }
        return Objects.equals(this.position, other.position);
    }
}

