/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.LatLong64;
import org.mitre.caasd.commons.LatLongPath;

public class LatLong64Path
implements Iterable<LatLong> {
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final long[] locationData;

    public LatLong64Path(Collection<LatLong> locations) {
        Objects.requireNonNull(locations);
        this.locationData = new long[locations.size() * 2];
        Iterator<LatLong> iter = locations.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LatLong loc = iter.next();
            this.locationData[i] = loc.compress().toPrimitiveLong();
            ++i;
        }
    }

    public LatLong64Path(LatLong ... locations) {
        Objects.requireNonNull(locations);
        this.locationData = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            this.locationData[i] = locations[i].compress().toPrimitiveLong();
        }
    }

    private LatLong64Path(long[] data) {
        Objects.requireNonNull(data);
        this.locationData = data;
    }

    public static LatLong64Path from(Collection<LatLong> locations) {
        return new LatLong64Path(locations);
    }

    public static LatLong64Path from(LatLong ... locations) {
        return new LatLong64Path(locations);
    }

    public static LatLong64Path from(LatLongPath path) {
        return new LatLong64Path(path.toArray());
    }

    public static LatLong64Path fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.length % 8 == 0 ? 1 : 0) != 0, (Object)"The byte[] must have a multiple of 8 bytes");
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long[] latLongData = new long[bytes.length / 8];
        for (int i = 0; i < latLongData.length; ++i) {
            latLongData[i] = buffer.getLong();
        }
        return new LatLong64Path(latLongData);
    }

    public static LatLong64Path fromBase64Str(String base64Encoding) {
        return LatLong64Path.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public LatLong64Path subpath(int beginIndex, int endIndex) {
        Preconditions.checkArgument((beginIndex >= 0 ? 1 : 0) != 0, (Object)"beginIndex cannot be negative");
        Preconditions.checkArgument((endIndex <= this.size() ? 1 : 0) != 0, (Object)"endIndex cannot be greater than size()");
        Preconditions.checkArgument((beginIndex <= endIndex ? 1 : 0) != 0, (Object)"endIndex must be >= beginIndex");
        int len = endIndex - beginIndex;
        long[] subset = new long[len];
        System.arraycopy(this.locationData, beginIndex, subset, 0, len);
        return new LatLong64Path(subset);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(8 * this.size());
        for (long locationAsLong : this.locationData) {
            buffer.putLong(locationAsLong);
        }
        return buffer.array();
    }

    public String toBase64() {
        return BASE_64_ENCODER.encodeToString(this.toBytes());
    }

    public LatLongPath inflate() {
        return LatLongPath.from(this.toArray());
    }

    public Stream<LatLong> stream() {
        return this.toList().stream();
    }

    public ArrayList<LatLong> toList() {
        ArrayList<LatLong> list = new ArrayList<LatLong>(this.size());
        for (long locationDatum : this.locationData) {
            list.add(LatLong64.fromPrimitiveLong(locationDatum).inflate());
        }
        return list;
    }

    public LatLong[] toArray() {
        LatLong[] array = new LatLong[this.locationData.length];
        for (int i = 0; i < this.locationData.length; ++i) {
            array[i] = LatLong64.fromPrimitiveLong(this.locationData[i]).inflate();
        }
        return array;
    }

    public LatLong64 get(int i) {
        Preconditions.checkArgument((0 <= i && i < this.locationData.length ? 1 : 0) != 0);
        return LatLong64.fromPrimitiveLong(this.locationData[i]);
    }

    public int size() {
        return this.locationData.length;
    }

    public boolean isEmpty() {
        return this.locationData.length == 0;
    }

    @Override
    public Iterator<LatLong> iterator() {
        return this.toList().iterator();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLong64Path latLongs = (LatLong64Path)o;
        return Arrays.equals(this.locationData, latLongs.locationData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.locationData);
    }
}

