/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.LatLong64Path;
import org.mitre.caasd.commons.util.IterPair;
import org.mitre.caasd.commons.util.NeighborIterator;
import org.mitre.caasd.commons.util.Preconditions;

public class LatLongPath
implements Iterable<LatLong> {
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final double[] latLongData;

    public LatLongPath(Collection<LatLong> locations) {
        Objects.requireNonNull(locations);
        this.latLongData = new double[locations.size() * 2];
        Iterator<LatLong> iter = locations.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LatLong loc = iter.next();
            this.latLongData[2 * i] = loc.latitude();
            this.latLongData[2 * i + 1] = loc.longitude();
            ++i;
        }
    }

    public LatLongPath(LatLong ... locations) {
        Objects.requireNonNull(locations);
        this.latLongData = new double[locations.length * 2];
        for (int i = 0; i < locations.length; ++i) {
            LatLong loc = locations[i];
            this.latLongData[2 * i] = loc.latitude();
            this.latLongData[2 * i + 1] = loc.longitude();
        }
    }

    private LatLongPath(double[] data) {
        this.latLongData = data;
    }

    public static LatLongPath from(Collection<LatLong> locations) {
        return new LatLongPath(locations);
    }

    public static LatLongPath from(LatLong ... locations) {
        return new LatLongPath(locations);
    }

    public LatLongPath subpath(int beginIndex, int endIndex) {
        com.google.common.base.Preconditions.checkArgument((beginIndex >= 0 ? 1 : 0) != 0, (Object)"beginIndex cannot be negative");
        com.google.common.base.Preconditions.checkArgument((endIndex <= this.size() ? 1 : 0) != 0, (Object)"endIndex cannot be greater than size()");
        com.google.common.base.Preconditions.checkArgument((beginIndex <= endIndex ? 1 : 0) != 0, (Object)"endIndex must be >= beginIndex");
        ArrayList<LatLong> data = new ArrayList<LatLong>();
        for (int i = beginIndex; i < endIndex; ++i) {
            data.add(this.get(i));
        }
        return new LatLongPath(data);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(16 * this.size());
        for (double latLongDatum : this.latLongData) {
            buffer.putDouble(latLongDatum);
        }
        return buffer.array();
    }

    public static LatLongPath fromBytes(byte[] bytes) {
        int i;
        Objects.requireNonNull(bytes);
        com.google.common.base.Preconditions.checkArgument((bytes.length % 16 == 0 ? 1 : 0) != 0, (Object)"The byte[] must have 16*X bytes");
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        double[] latLongData = new double[bytes.length / 8];
        for (i = 0; i < latLongData.length; ++i) {
            latLongData[i] = buffer.getDouble();
        }
        for (i = 0; i < latLongData.length; i += 2) {
            LatLong.checkLatitude(latLongData[i]);
            LatLong.checkLongitude(latLongData[i + 1]);
        }
        return new LatLongPath(latLongData);
    }

    public String toBase64() {
        return BASE_64_ENCODER.encodeToString(this.toBytes());
    }

    public LatLong64Path compress() {
        return LatLong64Path.from(this);
    }

    public static LatLongPath fromBase64Str(String base64Encoding) {
        return LatLongPath.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public Stream<LatLong> stream() {
        return this.toList().stream();
    }

    public ArrayList<LatLong> toList() {
        ArrayList<LatLong> list = new ArrayList<LatLong>(this.size());
        for (int i = 0; i < this.latLongData.length; i += 2) {
            list.add(LatLong.of(this.latLongData[i], this.latLongData[i + 1]));
        }
        return list;
    }

    public LatLong[] toArray() {
        LatLong[] array = new LatLong[this.latLongData.length / 2];
        for (int i = 0; i < this.latLongData.length; i += 2) {
            array[i / 2] = LatLong.of(this.latLongData[i], this.latLongData[i + 1]);
        }
        return array;
    }

    public double[][] toMatrix() {
        return new double[][]{this.latitudes(), this.longitudes()};
    }

    public double[] latitudes() {
        double[] latitudes = new double[this.size()];
        for (int i = 0; i < latitudes.length; ++i) {
            latitudes[i] = this.latLongData[2 * i];
        }
        return latitudes;
    }

    public double[] longitudes() {
        double[] latitudes = new double[this.size()];
        for (int i = 0; i < latitudes.length; ++i) {
            latitudes[i] = this.latLongData[2 * i + 1];
        }
        return latitudes;
    }

    public LatLong get(int i) {
        com.google.common.base.Preconditions.checkArgument((0 <= i && i <= this.latLongData.length / 2 ? 1 : 0) != 0);
        return LatLong.of(this.latLongData[2 * i], this.latLongData[2 * i + 1]);
    }

    public int size() {
        return this.latLongData.length / 2;
    }

    public boolean isEmpty() {
        return this.latLongData.length == 0;
    }

    public Distance pathDistance() {
        if (this.size() <= 1) {
            return Distance.ZERO;
        }
        NeighborIterator<LatLong> iter = new NeighborIterator<LatLong>(this.iterator());
        Distance sum = Distance.ZERO;
        while (iter.hasNext()) {
            Object curLeg = iter.next();
            Distance legDist = Distance.between((LatLong)((IterPair)curLeg).prior(), (LatLong)((IterPair)curLeg).current());
            sum = sum.plus(legDist);
        }
        return sum;
    }

    @Override
    public Iterator<LatLong> iterator() {
        return this.toList().iterator();
    }

    public Iterator<IterPair<LatLong>> legIterator() {
        return new NeighborIterator<LatLong>(this.iterator());
    }

    public LatLongPath append(LatLong ... locations) {
        Objects.requireNonNull(locations);
        if (locations.length == 0) {
            return this;
        }
        ArrayList<LatLong> list = this.toList();
        Collections.addAll(list, locations);
        return new LatLongPath(list);
    }

    public LatLongPath append(Collection<LatLong> locations) {
        Objects.requireNonNull(locations);
        if (locations.isEmpty()) {
            return this;
        }
        ArrayList<LatLong> list = this.toList();
        list.addAll(locations);
        return new LatLongPath(list);
    }

    public LatLongPath append(LatLongPath path2) {
        Objects.requireNonNull(path2);
        if (path2.size() == 0) {
            return this;
        }
        ArrayList<LatLong> list = this.toList();
        list.addAll(path2.toList());
        return new LatLongPath(list);
    }

    public static LatLongPath join(LatLongPath ... paths) {
        Objects.requireNonNull(paths);
        Preconditions.checkNoNullElement(paths);
        if (paths.length == 0) {
            return new LatLongPath(new LatLong[0]);
        }
        ArrayList<LatLong> allLatLongs = new ArrayList<LatLong>();
        for (LatLongPath path : paths) {
            allLatLongs.addAll(path.toList());
        }
        return new LatLongPath(allLatLongs);
    }

    public static LatLongPath join(Collection<LatLongPath> paths) {
        Objects.requireNonNull(paths);
        Preconditions.checkNoNullElement(paths);
        if (paths.isEmpty()) {
            return new LatLongPath(new LatLong[0]);
        }
        ArrayList<LatLong> allLatLongs = new ArrayList<LatLong>();
        for (LatLongPath path : paths) {
            allLatLongs.addAll(path.toList());
        }
        return new LatLongPath(allLatLongs);
    }

    public LatLong avgLatLong() {
        return LatLong.avgLatLong(this.toArray());
    }

    public LatLong quickAvgLatLong() {
        if (this.size() == 1) {
            return this.toArray()[0];
        }
        double avgLatitude = DoubleStream.of(this.latitudes()).average().getAsDouble();
        double[] longitudes = this.longitudes();
        double curAvgLongitude = longitudes[0];
        for (int i = 1; i < longitudes.length; ++i) {
            curAvgLongitude = this.avgLong(curAvgLongitude, i, longitudes[i], 1);
        }
        return LatLong.of(avgLatitude, curAvgLongitude);
    }

    private double avgLong(double longitudeA, int weightA, double longitudeB, int weightB) {
        double w1 = (double)weightA / (double)(weightA + weightB);
        double w2 = (double)weightB / (double)(weightA + weightB);
        double averageLong = Math.abs(longitudeA - longitudeB) > 180.0 ? w1 * (longitudeA + 180.0) + w2 * (longitudeB + 180.0) : w1 * longitudeA + w2 * longitudeB;
        return averageLong;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLongPath latLongs = (LatLongPath)o;
        return Arrays.equals(this.latLongData, latLongs.latLongData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.latLongData);
    }
}

