/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.HasPosition;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.LatLong;

public class Position
implements HasTime,
HasPosition {
    private final long epochTime;
    private final double latitude;
    private final double longitude;
    private final double altitudeInFeet;
    private final boolean altitudeIsValid;

    public Position(Instant time, LatLong location) {
        this(time, location, null);
    }

    public Position(Instant time, LatLong location, Distance altitude) {
        this(time.toEpochMilli(), location.latitude(), location.longitude(), Objects.nonNull(altitude) ? Double.valueOf(altitude.inFeet()) : null);
    }

    public Position(long epochTimeInMilli, double latitude, double longitude) {
        this(epochTimeInMilli, latitude, longitude, null);
    }

    public Position(long epochTimeInMilli, double latitude, double longitude, Double altInFeet) {
        LatLong.checkLatitude(latitude);
        LatLong.checkLongitude(longitude);
        this.epochTime = epochTimeInMilli;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitudeInFeet = Objects.nonNull(altInFeet) ? altInFeet : 0.0;
        this.altitudeIsValid = Objects.nonNull(altInFeet);
    }

    private Position() {
        this(0L, 0.0, 0.0, null);
    }

    @Override
    public Instant time() {
        return Instant.ofEpochMilli(this.epochTime);
    }

    @Override
    public LatLong latLong() {
        return LatLong.of(this.latitude, this.longitude);
    }

    public Distance altitude() {
        return this.altitudeIsValid ? Distance.ofFeet(this.altitudeInFeet) : null;
    }

    public Optional<Distance> altitudeAsOpt() {
        return Optional.ofNullable(this.altitude());
    }

    public boolean hasAltitude() {
        return this.altitudeIsValid;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (int)(this.epochTime ^ this.epochTime >>> 32);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.altitudeInFeet) ^ Double.doubleToLongBits(this.altitudeInFeet) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.epochTime != other.epochTime) {
            return false;
        }
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.altitudeInFeet) == Double.doubleToLongBits(other.altitudeInFeet);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Position seed) {
        return Position.builder().time(seed.time()).latLong(seed.latLong()).altitude(seed.altitude());
    }

    public static class Builder {
        private Long epochTime;
        private Double latitude;
        private Double longitude;
        private Double altitudeInFeet;

        public Position build() {
            Objects.requireNonNull(this.epochTime);
            Objects.requireNonNull(this.latitude);
            Objects.requireNonNull(this.longitude);
            return new Position(this.epochTime, this.latitude, this.longitude, this.altitudeInFeet);
        }

        public Builder time(Instant time) {
            Preconditions.checkState((boolean)Objects.isNull(this.epochTime), (Object)"time was already set");
            return this.butTime(time);
        }

        public Builder butTime(Instant time) {
            this.epochTime = time.toEpochMilli();
            return this;
        }

        public Builder latLong(LatLong location) {
            Preconditions.checkState((boolean)Objects.isNull(this.latitude), (Object)"latitude was already set");
            Preconditions.checkState((boolean)Objects.isNull(this.longitude), (Object)"longitude was already set");
            return this.butLatLong(location);
        }

        public Builder butLatLong(LatLong location) {
            Objects.requireNonNull(location);
            return this.butLatLong(location.latitude(), location.longitude());
        }

        public Builder latLong(double lat, double lon) {
            Preconditions.checkState((boolean)Objects.isNull(this.latitude), (Object)"latitude was already set");
            Preconditions.checkState((boolean)Objects.isNull(this.longitude), (Object)"longitude was already set");
            return this.butLatLong(lat, lon);
        }

        public Builder butLatLong(double latitude, double longitude) {
            LatLong.checkLatitude(latitude);
            LatLong.checkLongitude(longitude);
            this.latitude = latitude;
            this.longitude = longitude;
            return this;
        }

        public Builder altitude(Distance altitude) {
            Preconditions.checkState((boolean)Objects.isNull(this.altitudeInFeet), (Object)"altitude was already set");
            return this.butAltitude(altitude);
        }

        public Builder butAltitude(Distance altitude) {
            this.altitudeInFeet = Objects.isNull(altitude) ? null : Double.valueOf(altitude.inFeet());
            return this;
        }

        public Builder altitudeInFeet(double altitudeInFeet) {
            Preconditions.checkState((boolean)Objects.isNull(this.altitudeInFeet), (Object)"altitude was already set");
            return this.butAltitudeInFeet(altitudeInFeet);
        }

        public Builder butAltitudeInFeet(double altitudeInFeet) {
            this.altitudeInFeet = altitudeInFeet;
            return this;
        }
    }
}

