/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.time.Instant;
import java.util.Objects;
import java.util.function.Function;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.HasPosition;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.Position;

public class PositionRecord<T>
implements HasTime,
HasPosition {
    private final T datum;
    private final Position position;

    public PositionRecord(T item, Position position) {
        Objects.requireNonNull(item);
        Objects.requireNonNull(position);
        this.datum = item;
        this.position = position;
    }

    public PositionRecord(T item, Function<T, Position> positionExtractor) {
        Objects.requireNonNull(item);
        Objects.requireNonNull(positionExtractor);
        this.datum = item;
        this.position = positionExtractor.apply(this.datum);
    }

    private PositionRecord() {
        this.datum = null;
        this.position = null;
    }

    public static <T> PositionRecord<T> of(T item, Position pos) {
        return new PositionRecord<T>(item, pos);
    }

    public static <T> PositionRecord<T> of(T item, Function<T, Position> positionExtractor) {
        return new PositionRecord<T>(item, positionExtractor);
    }

    public T datum() {
        return this.datum;
    }

    public Position position() {
        return this.position;
    }

    @Override
    public Instant time() {
        return this.position().time();
    }

    @Override
    public LatLong latLong() {
        return this.position().latLong();
    }

    public Distance altitude() {
        return this.position().altitude();
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.datum);
        hash = 11 * hash + Objects.hashCode(this.position);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionRecord other = (PositionRecord)obj;
        if (!Objects.equals(this.datum, other.datum)) {
            return false;
        }
        return Objects.equals(this.position, other.position);
    }
}

