/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.mitre.caasd.commons.LatLong;

public final class Rhumb {
    private Rhumb() {
    }

    public static double rhumbDistance(double lat1, double lon1, double lat2, double lon2) {
        double distanceRadians;
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double dLat = lat2 - lat1;
        double dLon = lon2 - lon1;
        double dPhi = FastMath.log((double)(FastMath.tan((double)(lat2 / 2.0 + 0.7853981633974483)) / FastMath.tan((double)(lat1 / 2.0 + 0.7853981633974483))));
        double q = dLat / dPhi;
        if (Double.isNaN(dPhi) || Double.isNaN(q)) {
            q = FastMath.cos((double)lat1);
        }
        if (FastMath.abs((double)dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        return Double.isNaN(distanceRadians = FastMath.sqrt((double)(dLat * dLat + q * q * dLon * dLon))) ? 0.0 : distanceRadians;
    }

    public static double rhumbDistance(LatLong p1, LatLong p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        return Rhumb.rhumbDistance(FastMath.toRadians((double)p1.latitude()), FastMath.toRadians((double)p1.longitude()), FastMath.toRadians((double)p2.latitude()), FastMath.toRadians((double)p2.longitude()));
    }

    public static double rhumbAzimuth(double lat1, double lon1, double lat2, double lon2) {
        double azimuthRadians;
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double dLon = lon2 - lon1;
        double dPhi = FastMath.log((double)(FastMath.tan((double)(lat2 / 2.0 + 0.7853981633974483)) / FastMath.tan((double)(lat1 / 2.0 + 0.7853981633974483))));
        if (FastMath.abs((double)dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        return Double.isNaN(azimuthRadians = FastMath.atan2((double)dLon, (double)dPhi)) ? 0.0 : azimuthRadians;
    }

    public static double rhumbAzimuth(LatLong p1, LatLong p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        return Rhumb.rhumbAzimuth(FastMath.toRadians((double)p1.latitude()), FastMath.toRadians((double)p1.longitude()), FastMath.toRadians((double)p2.latitude()), FastMath.toRadians((double)p2.longitude()));
    }

    public static LatLong rhumbEndPosition(double lat1, double lon1, double rhumbAzimuth, double pathLength) {
        if (pathLength == 0.0) {
            return LatLong.of(lat1, lon1);
        }
        double lat2 = lat1 + pathLength * FastMath.cos((double)rhumbAzimuth);
        double dPhi = FastMath.log((double)(FastMath.tan((double)(lat2 / 2.0 + 0.7853981633974483)) / FastMath.tan((double)(lat1 / 2.0 + 0.7853981633974483))));
        double q = (lat2 - lat1) / dPhi;
        if (Double.isNaN(dPhi) || Double.isNaN(q) || Double.isInfinite(q)) {
            q = FastMath.cos((double)lat1);
        }
        double dLon = pathLength * FastMath.sin((double)rhumbAzimuth) / q;
        if (FastMath.abs((double)lat2) > 1.5707963267948966) {
            lat2 = lat2 > 0.0 ? Math.PI - lat2 : -Math.PI - lat2;
        }
        double lon2 = (lon1 + dLon + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Double.isNaN(lat2) || Double.isNaN(lon2)) {
            return LatLong.of(lat1, lon1);
        }
        return LatLong.of(Rhumb.normalizedDegreesLatitude(FastMath.toDegrees((double)lat2)), Rhumb.normalizedDegreesLongitude(FastMath.toDegrees((double)lon2)));
    }

    public static LatLong rhumbEndPosition(LatLong p, double rhumbAzimuth, double pathLength) {
        Objects.requireNonNull(p);
        return Rhumb.rhumbEndPosition(FastMath.toRadians((double)p.latitude()), FastMath.toRadians((double)p.longitude()), rhumbAzimuth, pathLength);
    }

    private static double normalizedDegreesLatitude(double degrees) {
        double lat = degrees % 180.0;
        return lat > 90.0 ? 180.0 - lat : (lat < -90.0 ? -180.0 - lat : lat);
    }

    private static double normalizedDegreesLongitude(double degrees) {
        double lon = degrees % 360.0;
        return lon > 180.0 ? lon - 360.0 : (lon < -180.0 ? 360.0 + lon : lon);
    }
}

