/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.InstantIterator;
import org.mitre.caasd.commons.Time;

public class TimeWindow
implements Serializable {
    private final Instant start;
    private final Instant end;

    public TimeWindow(Instant start, Instant end) {
        this.start = Objects.requireNonNull(start, "The start of the time window cannot be null");
        this.end = Objects.requireNonNull(end, "The end of the time window cannot be null");
        Preconditions.checkArgument((!start.isAfter(end) ? 1 : 0) != 0, (Object)"The start of a TimeWindow cannot come after the end of a TimeWindow");
    }

    public static TimeWindow of(Instant start, Instant end) {
        return new TimeWindow(start, end);
    }

    public static <T extends HasTime> TimeWindow enclosingWindow(Collection<T> items) {
        ArrayList list = Lists.newArrayList(items);
        list.sort(Time.compareByTime());
        HasTime start = (HasTime)list.get(0);
        HasTime end = (HasTime)list.get(list.size() - 1);
        return new TimeWindow(start.time(), end.time());
    }

    public TimeWindow pad(Duration duration) {
        return new TimeWindow(this.start.minus(duration), this.end.plus(duration));
    }

    public TimeWindow shift(Duration duration) {
        Objects.requireNonNull(duration, "The slide duration cannot be null");
        return new TimeWindow(this.start.plus(duration), this.end.plus(duration));
    }

    public TimeWindow shiftMillis(long milliseconds) {
        return new TimeWindow(this.start.plusMillis(milliseconds), this.end.plusMillis(milliseconds));
    }

    public static ArrayList<TimeWindow> shiftAll(Collection<TimeWindow> windows, Duration duration) {
        Objects.requireNonNull(windows, "The List<TimeWindow> cannot be null");
        Objects.requireNonNull(duration, "The slide duration cannot be null");
        return windows.stream().map(w -> w.shift(duration)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ArrayList<TimeWindow> shiftAll(Collection<TimeWindow> windows, long millis) {
        Objects.requireNonNull(windows, "The List<TimeWindow> cannot be null");
        return windows.stream().map(w -> w.shiftMillis(millis)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Duration length() {
        return this.duration();
    }

    public Duration duration() {
        return Duration.between(this.start, this.end);
    }

    public boolean isEmpty() {
        return !this.start().isBefore(this.end());
    }

    public boolean contains(Instant instant) {
        boolean afterStart = instant.isAfter(this.start) || instant.equals(this.start);
        boolean beforeEnd = instant.isBefore(this.end) || instant.equals(this.end);
        return afterStart && beforeEnd;
    }

    public boolean overlapsWith(TimeWindow other) {
        Preconditions.checkNotNull((Object)other);
        Instant startOfOverlap = Time.latest(this.start, other.start);
        Instant endOfOverlap = Time.earliest(this.end, other.end);
        return startOfOverlap.isBefore(endOfOverlap) || startOfOverlap.equals(endOfOverlap);
    }

    public Optional<TimeWindow> getOverlapWith(TimeWindow other) {
        Preconditions.checkNotNull((Object)other);
        Instant startOfOverlap = Time.latest(this.start, other.start);
        Instant endOfOverlap = Time.earliest(this.end, other.end);
        if (startOfOverlap.isBefore(endOfOverlap) || startOfOverlap.equals(endOfOverlap)) {
            return Optional.of(TimeWindow.of(startOfOverlap, endOfOverlap));
        }
        return Optional.empty();
    }

    public double toFractionOfRange(Instant t) {
        Preconditions.checkNotNull((Object)t, (Object)"The input time t cannot be null");
        long msBetweenStartAndT = Duration.between(this.start, t).toMillis();
        long msInRange = this.duration().toMillis();
        double castedNumerator = msBetweenStartAndT;
        double castedDenominator = msInRange;
        return castedNumerator / castedDenominator;
    }

    public Instant instantWithin(double fraction) {
        Preconditions.checkArgument((fraction >= 0.0 ? 1 : 0) != 0, (Object)("Input fraction must be at least 0: " + fraction));
        Preconditions.checkArgument((fraction <= 1.0 ? 1 : 0) != 0, (Object)("Input fraction can be no greater than 1: " + fraction));
        long durationAsMillis = this.duration().toMillis();
        long delta = (long)(fraction * (double)durationAsMillis);
        return this.start().plusMillis(delta);
    }

    public Iterator<Instant> iterator(Duration timeStep) {
        Preconditions.checkNotNull((Object)timeStep, (Object)"The timeStep cannot be null");
        Preconditions.checkArgument((!timeStep.isNegative() ? 1 : 0) != 0, (Object)"The timeStep cannot be negative");
        Preconditions.checkArgument((!timeStep.isZero() ? 1 : 0) != 0, (Object)"The timeStep cannot be zero");
        return new InstantIterator(this.start, this.end, timeStep);
    }

    public ArrayList<Instant> steppedIteration(Duration timeStep) {
        return Lists.newArrayList(this.iterator(timeStep));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.start);
        hash = 31 * hash + Objects.hashCode(this.end);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeWindow other = (TimeWindow)obj;
        if (!Objects.equals(this.start, other.start)) {
            return false;
        }
        return Objects.equals(this.end, other.end);
    }
}

