/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;

public class YyyyMmDd
implements Comparable<YyyyMmDd> {
    private final String date;
    private static final String DATE_FORMAT_ERROR = "Date not specified as YYYY-MM-DD format";

    public YyyyMmDd(Instant time) {
        Preconditions.checkNotNull((Object)time);
        this.date = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC).format(time);
    }

    public static YyyyMmDd today() {
        return new YyyyMmDd(Instant.now());
    }

    public YyyyMmDd(String date) {
        Preconditions.checkNotNull((Object)date);
        YyyyMmDd.verifyYearMonthDayFormat(date);
        this.date = date;
    }

    public static YyyyMmDd from(Instant time) {
        return new YyyyMmDd(time);
    }

    public static YyyyMmDd of(String date) {
        return new YyyyMmDd(date);
    }

    public String date() {
        return this.date;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.date);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YyyyMmDd other = (YyyyMmDd)obj;
        return Objects.equals(this.date, other.date);
    }

    @Override
    public int compareTo(YyyyMmDd o) {
        return this.date.compareTo(o.date);
    }

    public String toString() {
        return this.date;
    }

    public DayOfWeek dayOfWeek() {
        return DayOfWeek.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(this.date));
    }

    public Instant asInstant() {
        return Instant.parse(this.date + "T00:00:00.000Z");
    }

    public YyyyMmDd yesterday() {
        return YyyyMmDd.from(this.asInstant().minus(Duration.ofDays(1L)));
    }

    public YyyyMmDd tomorrow() {
        return YyyyMmDd.from(this.asInstant().plus(Duration.ofDays(1L)));
    }

    public static YyyyMmDd oldestOf(Collection<YyyyMmDd> dates) {
        Preconditions.checkNotNull(dates);
        return dates.stream().min(Comparator.naturalOrder()).orElse(null);
    }

    public static YyyyMmDd newestOf(Collection<YyyyMmDd> dates) {
        Preconditions.checkNotNull(dates);
        return dates.stream().max(Comparator.naturalOrder()).orElse(null);
    }

    public static void verifyYearMonthDayFormat(String date) {
        Preconditions.checkNotNull((Object)date);
        try {
            DateTimeFormatter.ISO_LOCAL_DATE.parse(date);
        }
        catch (DateTimeParseException dtpe) {
            throw new IllegalArgumentException("ISO_LOCAL_DATE cannot parse: " + date);
        }
    }
}

