/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.collect.CenterPointSelector;
import org.mitre.caasd.commons.collect.DistanceMetric;

public class CenterPointSelectors {
    public static <K> CenterPointSelector<K> singleRandomSample(long randomSeed) {
        return new RandomCenterSelector(randomSeed);
    }

    public static <K> CenterPointSelector<K> maxOfRandomSamples() {
        return new RandomizedMaxDistanceSelector();
    }

    private static <KEY> Pair<KEY, KEY> selectRandomPairOfKeys(List<KEY> keys, Random rng) {
        int n = keys.size();
        int index1 = rng.nextInt(n);
        int index2 = rng.nextInt(n);
        while (index1 == index2) {
            index2 = rng.nextInt(n);
        }
        return Pair.of(keys.get(index1), keys.get(index2));
    }

    private static class RandomizedMaxDistanceSelector<K>
    implements CenterPointSelector<K> {
        private static final long serialVersionUID = 1L;
        Random rng = new Random(17L);

        private RandomizedMaxDistanceSelector() {
        }

        @Override
        public Pair<K, K> selectNewCenterPoints(List<K> keys, DistanceMetric<K> metric) {
            int numPairsToDraw = (int)Math.sqrt(keys.size());
            Pair bestPair = CenterPointSelectors.selectRandomPairOfKeys(keys, this.rng);
            double biggestDistance = metric.distanceBtw(bestPair.first(), bestPair.second());
            --numPairsToDraw;
            for (int i = 0; i < numPairsToDraw; ++i) {
                Pair newPair = CenterPointSelectors.selectRandomPairOfKeys(keys, this.rng);
                double newDistance = metric.distanceBtw(newPair.first(), newPair.second());
                if (!(newDistance > biggestDistance)) continue;
                bestPair = newPair;
                biggestDistance = newDistance;
            }
            return bestPair;
        }
    }

    private static class RandomCenterSelector<K>
    implements CenterPointSelector<K> {
        private static final long serialVersionUID = 1L;
        private final Random rng;

        private RandomCenterSelector(long seed) {
            this.rng = new Random(seed);
        }

        @Override
        public Pair<K, K> selectNewCenterPoints(List<K> keys, DistanceMetric<K> metric) {
            Preconditions.checkArgument((keys.size() > 2 ? 1 : 0) != 0);
            return CenterPointSelectors.selectRandomPairOfKeys(keys, this.rng);
        }
    }
}

