/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.collect.DistanceMetric;
import org.mitre.caasd.commons.collect.MetricTree;
import org.mitre.caasd.commons.collect.SearchResult;

class Search<KEY, VALUE> {
    private final DistanceMetric<KEY> metric;
    private final SearchType type;
    private final KEY searchKey;
    private final int maxNumResults;
    private final double fixedRadius;
    private final PriorityQueue<SearchResult<KEY, VALUE>> queue;

    Search(KEY searchKey, int maxNumResults, DistanceMetric<KEY> metric) {
        this.metric = metric;
        this.type = SearchType.K_NEAREST_NEIGHBORS;
        this.searchKey = searchKey;
        this.maxNumResults = maxNumResults;
        this.fixedRadius = Double.POSITIVE_INFINITY;
        this.queue = new PriorityQueue();
    }

    Search(KEY searchKey, DistanceMetric<KEY> metric, double range) {
        this.metric = metric;
        this.type = SearchType.RANGE;
        this.searchKey = searchKey;
        this.maxNumResults = Integer.MAX_VALUE;
        this.fixedRadius = range;
        this.queue = new PriorityQueue();
    }

    void startQuery(MetricTree.Sphere root) {
        ArrayDeque<MetricTree.Sphere> stackOfNodesToSearch = new ArrayDeque<MetricTree.Sphere>();
        stackOfNodesToSearch.push(root);
        while (!stackOfNodesToSearch.isEmpty()) {
            double secondDist;
            MetricTree.Sphere currentNode = (MetricTree.Sphere)stackOfNodesToSearch.pop();
            if (!this.overlapsWith(currentNode)) continue;
            if (currentNode.isSphereOfPoints()) {
                this.ingestSphereOfPoints(currentNode);
                continue;
            }
            Pair<MetricTree.Sphere, MetricTree.Sphere> childSpheres = currentNode.children();
            double firstDist = this.metric.distanceBtw(this.searchKey, childSpheres.first().centerPoint);
            if (firstDist < (secondDist = this.metric.distanceBtw(this.searchKey, childSpheres.second().centerPoint))) {
                stackOfNodesToSearch.push(childSpheres.second());
                stackOfNodesToSearch.push(childSpheres.first());
                continue;
            }
            stackOfNodesToSearch.push(childSpheres.first());
            stackOfNodesToSearch.push(childSpheres.second());
        }
    }

    private void ingestSphereOfPoints(MetricTree.Sphere inputSphere) {
        for (Map.Entry entry : inputSphere.points()) {
            SearchResult r = new SearchResult(entry.getKey(), entry.getValue(), this.metric.distanceBtw(this.searchKey, entry.getKey()));
            if (!(r.distance <= this.radius())) continue;
            this.queue.offer(r);
            if (this.queue.size() <= this.maxNumResults) continue;
            this.queue.poll();
        }
    }

    private boolean overlapsWith(MetricTree.Sphere s) {
        double distance = this.metric.distanceBtw(s.centerPoint, this.searchKey);
        double overlap = s.radius() + this.radius() - distance;
        return overlap >= 0.0;
    }

    private double radius() {
        if (this.type == SearchType.K_NEAREST_NEIGHBORS) {
            if (this.queue.size() < this.maxNumResults) {
                return Double.POSITIVE_INFINITY;
            }
            return this.queue.peek().distance;
        }
        if (this.type == SearchType.RANGE) {
            return this.fixedRadius;
        }
        throw new AssertionError((Object)"Should never get here");
    }

    Collection<SearchResult<KEY, VALUE>> results() {
        return this.queue;
    }

    private static enum SearchType {
        K_NEAREST_NEIGHBORS,
        RANGE;

    }
}

