/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.primitives.Doubles;
import java.util.Objects;

public class SearchResult<K, V>
implements Comparable<SearchResult<K, V>> {
    final K key;
    final V value;
    final double distance;

    SearchResult(K key, V value, double distance) {
        this.key = key;
        this.value = value;
        this.distance = distance;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public double distance() {
        return this.distance;
    }

    @Override
    public int compareTo(SearchResult<K, V> other) {
        return Doubles.compare((double)other.distance, (double)this.distance);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.key);
        hash = 79 * hash + Objects.hashCode(this.value);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

