/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.PriorityQueue;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.collect.DistanceMetric;
import org.mitre.caasd.commons.collect.MetricSet;
import org.mitre.caasd.commons.collect.SetSearchResult;

class SetSearch<K> {
    private final DistanceMetric<K> metric;
    private final SearchType type;
    private final K searchKey;
    private final int maxNumResults;
    private final double fixedRadius;
    private final PriorityQueue<SetSearchResult<K>> queue;

    SetSearch(K searchKey, int maxNumResults, DistanceMetric<K> metric) {
        this.metric = metric;
        this.type = SearchType.K_NEAREST_NEIGHBORS;
        this.searchKey = searchKey;
        this.maxNumResults = maxNumResults;
        this.fixedRadius = Double.POSITIVE_INFINITY;
        this.queue = new PriorityQueue();
    }

    SetSearch(K searchKey, DistanceMetric<K> metric, double range) {
        this.metric = metric;
        this.type = SearchType.RANGE;
        this.searchKey = searchKey;
        this.maxNumResults = Integer.MAX_VALUE;
        this.fixedRadius = range;
        this.queue = new PriorityQueue();
    }

    void startQuery(MetricSet.Sphere root) {
        ArrayDeque<MetricSet.Sphere> stack = new ArrayDeque<MetricSet.Sphere>();
        stack.push(root);
        while (!stack.isEmpty()) {
            double secondDist;
            MetricSet.Sphere current = (MetricSet.Sphere)stack.pop();
            if (!this.overlapsWith(current)) continue;
            if (current.isSphereOfPoints()) {
                this.ingestSphereOfPoints(current);
                continue;
            }
            Pair<MetricSet.Sphere, MetricSet.Sphere> childSpheres = current.children();
            double firstDist = this.metric.distanceBtw(this.searchKey, childSpheres.first().centerPoint);
            if (firstDist < (secondDist = this.metric.distanceBtw(this.searchKey, childSpheres.second().centerPoint))) {
                stack.push(childSpheres.second());
                stack.push(childSpheres.first());
                continue;
            }
            stack.push(childSpheres.first());
            stack.push(childSpheres.second());
        }
    }

    private void ingestSphereOfPoints(MetricSet.Sphere inputSphere) {
        for (Object key : inputSphere.points()) {
            SetSearchResult r = new SetSearchResult(key, this.metric.distanceBtw(this.searchKey, key));
            if (!(r.distance <= this.radius())) continue;
            this.queue.offer(r);
            if (this.queue.size() <= this.maxNumResults) continue;
            this.queue.poll();
        }
    }

    private boolean overlapsWith(MetricSet.Sphere s) {
        double distance = this.metric.distanceBtw(s.centerPoint, this.searchKey);
        double overlap = s.radius() + this.radius() - distance;
        return overlap >= 0.0;
    }

    private double radius() {
        if (this.type == SearchType.K_NEAREST_NEIGHBORS) {
            if (this.queue.size() < this.maxNumResults) {
                return Double.POSITIVE_INFINITY;
            }
            return this.queue.peek().distance;
        }
        if (this.type == SearchType.RANGE) {
            return this.fixedRadius;
        }
        throw new AssertionError((Object)"Should never get here");
    }

    Collection<SetSearchResult<K>> results() {
        return this.queue;
    }

    private static enum SearchType {
        K_NEAREST_NEIGHBORS,
        RANGE;

    }
}

