/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.fileutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.util.DemotedException;

public class FileLineIterator
implements Iterator<String>,
AutoCloseable {
    private final BufferedReader reader;
    private String nextLine;

    public FileLineIterator(String fileName) {
        this(new File(fileName));
    }

    public FileLineIterator(File file) {
        try {
            this.reader = FileUtils.createReaderFor(file);
            this.updateNext();
        }
        catch (IOException ioe) {
            throw DemotedException.demote(ioe);
        }
    }

    public FileLineIterator(Reader reader) {
        this(new BufferedReader(reader));
    }

    public FileLineIterator(BufferedReader reader) {
        this.reader = Objects.requireNonNull(reader);
        this.updateNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException();
        }
        String returnMe = this.nextLine;
        this.updateNext();
        return returnMe;
    }

    private void updateNext() {
        this.retrieveNextLine();
        this.closeReaderIfDone();
    }

    private void retrieveNextLine() {
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (IOException ioe) {
            throw DemotedException.demote("Could not load the next line of the input file", ioe);
        }
    }

    private void closeReaderIfDone() {
        try {
            if (!this.hasNext()) {
                this.close();
            }
        }
        catch (IOException ioe) {
            throw DemotedException.demote("Could not close the BufferedReader", ioe);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("A LineIterator cannot manipulate a text file.");
    }

    @Override
    public void close() throws IOException {
        this.nextLine = null;
        this.reader.close();
    }
}

