/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.func;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class TranslatingConsumer<BEFORE, AFTER>
implements Consumer<BEFORE> {
    private final Function<BEFORE, AFTER> translator;
    private final Consumer<AFTER> downStream;

    public TranslatingConsumer(Function<BEFORE, AFTER> translator, Consumer<AFTER> downStream) {
        this.translator = Objects.requireNonNull(translator);
        this.downStream = Objects.requireNonNull(downStream);
    }

    public static <IN, OUT> TranslatingConsumer<IN, OUT> of(Function<IN, OUT> translator, Consumer<OUT> downStream) {
        return new TranslatingConsumer<IN, OUT>(translator, downStream);
    }

    @Override
    public void accept(BEFORE input) {
        AFTER item = this.translator.apply(input);
        this.downStream.accept(item);
    }

    public Function<BEFORE, AFTER> translator() {
        return this.translator;
    }

    public Consumer<AFTER> consumer() {
        return this.downStream;
    }
}

