/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.ids;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.time.Instant;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.mitre.caasd.commons.ids.SmallTimeId;
import org.mitre.caasd.commons.ids.TimeIds;

public class IdFactoryShard
implements TimeIds.IdFactory<SmallTimeId> {
    private final int numBitsForShardNumber;
    private final int numBitsForItemDistinction;
    private final int shardIndex;
    private final int numShardsInTeam;
    private final int limitTimeIdsPerEpochMills;
    private final CountKeeper timeCounts;

    public IdFactoryShard(int shardIndex, int totalShardCount, CountKeeper countKeeper) {
        Preconditions.checkArgument((shardIndex >= 0 ? 1 : 0) != 0, (Object)"The shardIndex cannot be negative");
        Preconditions.checkArgument((totalShardCount >= 1 ? 1 : 0) != 0, (Object)"The totalShardCount must be at least 1");
        Preconditions.checkArgument((IdFactoryShard.numBitsRequiredFor(totalShardCount) < 21 ? 1 : 0) != 0);
        Preconditions.checkArgument((shardIndex < totalShardCount ? 1 : 0) != 0, (Object)"The shardIndex must be smaller than totalShardCount");
        Objects.requireNonNull(countKeeper);
        this.shardIndex = shardIndex;
        this.numShardsInTeam = totalShardCount;
        this.numBitsForShardNumber = IdFactoryShard.numBitsRequiredFor(totalShardCount);
        this.numBitsForItemDistinction = 21 - this.numBitsForShardNumber;
        this.limitTimeIdsPerEpochMills = (int)Math.pow(2.0, this.numBitsForItemDistinction());
        this.timeCounts = countKeeper;
    }

    public IdFactoryShard(int shardIndex, int totalShardCount) {
        this(shardIndex, totalShardCount, IdFactoryShard.inMemoryCounter());
    }

    public static <T extends Enum<T>> IdFactoryShard newFactoryShardFor(T memberOfEnum) {
        int enumElementIndex = memberOfEnum.ordinal();
        int sizeOfEnumSpace = ((Enum[])memberOfEnum.getClass().getEnumConstants()).length;
        return new IdFactoryShard(enumElementIndex, sizeOfEnumSpace);
    }

    public int limitTimeIdsPerEpochMills() {
        return this.limitTimeIdsPerEpochMills;
    }

    public int numBitsToStoreShardIndex() {
        return this.numBitsForShardNumber;
    }

    public int numBitsForItemDistinction() {
        return this.numBitsForItemDistinction;
    }

    public int shardIndex() {
        return this.shardIndex;
    }

    public int numShardsInTeam() {
        return this.numShardsInTeam;
    }

    @Override
    public SmallTimeId generateIdFor(Instant time) {
        return this.generate(time, this.timeCounts.nextCountFor(time));
    }

    private SmallTimeId generate(Instant time, int count) {
        if (count >= this.limitTimeIdsPerEpochMills) {
            throw new NoSuchElementException("Too many requests (" + count + ") for a TimeId at: " + time.toString() + " have been made. Only" + this.numBitsForItemDistinction + " bits are allocated to  store the counter therefore a limit of " + this.limitTimeIdsPerEpochMills + " is imposed");
        }
        long shardBits = (long)this.shardIndex << this.numBitsForItemDistinction;
        long itemBits = count;
        long comboBits = shardBits | itemBits;
        return TimeIds.directBitsetTimeId(time, comboBits);
    }

    public static int numBitsRequiredFor(int numShards) {
        Preconditions.checkArgument((numShards > 0 ? 1 : 0) != 0);
        return (int)Math.ceil(DoubleMath.log2((double)numShards));
    }

    public static CountKeeper inMemoryCounter() {
        return new InMemoryCountKeeper();
    }

    public static CountKeeper limitedMemoryCounter(int numTimesTracked) {
        return new CappedInMemoryCountKeeper(numTimesTracked);
    }

    private static class CappedInMemoryCountKeeper
    implements CountKeeper {
        private final TreeMap<Long, Integer> timeCounts;
        private long lastEvictedTime;
        private final int maxSize;

        CappedInMemoryCountKeeper(int maxSize) {
            Preconditions.checkArgument((maxSize >= 1 ? 1 : 0) != 0);
            this.maxSize = maxSize;
            this.timeCounts = new TreeMap();
            this.lastEvictedTime = Long.MIN_VALUE;
        }

        @Override
        public int nextCountFor(Instant timestamp) {
            if (timestamp.toEpochMilli() <= this.lastEvictedTime) {
                throw new IllegalStateException("Cannot generate count for: " + timestamp + ", it occurs too far in the past");
            }
            int count = this.timeCounts.merge(timestamp.toEpochMilli(), 1, Integer::sum);
            this.enforceSizeLimit();
            return count - 1;
        }

        private void enforceSizeLimit() {
            if (this.timeCounts.size() > this.maxSize) {
                this.lastEvictedTime = this.timeCounts.pollFirstEntry().getKey();
            }
        }
    }

    private static class InMemoryCountKeeper
    implements CountKeeper {
        private final ConcurrentHashMap<Long, Integer> timeCounts = new ConcurrentHashMap();

        InMemoryCountKeeper() {
        }

        @Override
        public int nextCountFor(Instant timestamp) {
            return this.timeCounts.merge(timestamp.toEpochMilli(), 1, Integer::sum) - 1;
        }
    }

    public static interface CountKeeper {
        public int nextCountFor(Instant var1);
    }
}

