/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.ids;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.util.BitAndHashingUtils;

public class SmallTimeId
implements Comparable<SmallTimeId>,
HasTime,
Serializable {
    private static final long serialVersionUID = 6470927123705680470L;
    private static final int NUM_BITS_FOR_TIMESTAMP = 42;
    static final int NUM_BITS_FOR_DISTINGUISHING_ITEMS = 21;
    private static final long BIT_MASK_FOR_DISTINGUISHING_BITS = BitAndHashingUtils.makeBitMask(21);
    private final long idBits;
    private static final long HASH_MASK = BitAndHashingUtils.makeBitMask(32);

    public SmallTimeId(Instant time, long twentyOneBits) {
        long timeBasedBits = BitAndHashingUtils.truncateBits(time.toEpochMilli(), 42);
        long distinguishingBits = BitAndHashingUtils.truncateBits(twentyOneBits, 21);
        this.idBits = timeBasedBits << 21 | distinguishingBits;
    }

    @Override
    public Instant time() {
        return Instant.ofEpochMilli(this.idBits >> 21);
    }

    @Override
    public long timeAsEpochMs() {
        return this.idBits >> 21;
    }

    public long id() {
        return this.idBits;
    }

    public String toString() {
        return String.format("%016x", this.idBits);
    }

    public static SmallTimeId fromString(String hexStr) {
        Objects.requireNonNull(hexStr);
        Preconditions.checkArgument((hexStr.length() == 16 ? 1 : 0) != 0, (Object)"Exactly 16 hexadecimal chars are required");
        long bits = new BigInteger(hexStr, 16).longValue();
        Instant time = Instant.ofEpochMilli(bits >> 21);
        return new SmallTimeId(time, bits);
    }

    public long nonTimeBits() {
        return this.idBits & BIT_MASK_FOR_DISTINGUISHING_BITS;
    }

    @Override
    public int compareTo(SmallTimeId other) {
        return Long.compare(this.idBits, other.idBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmallTimeId timeId = (SmallTimeId)o;
        return this.idBits == timeId.idBits;
    }

    public int hashCode() {
        return (int)(HASH_MASK & this.idBits);
    }
}

