/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import org.mitre.caasd.commons.maps.TileAddress;
import org.mitre.caasd.commons.maps.TileServer;

public class DebugTileServer
implements TileServer {
    int tileSize = 512;

    @Override
    public int maxZoomLevel() {
        return 20;
    }

    @Override
    public int maxTileSize() {
        return 512;
    }

    @Override
    public URL getUrlFor(TileAddress ta) {
        throw new UnsupportedOperationException("URLs are not provided because single color tiles can be created directly");
    }

    @Override
    public BufferedImage downloadMap(TileAddress ta) {
        BufferedImage img = new BufferedImage(this.tileSize, this.tileSize, 5);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.WHITE);
        g.drawRect(0, 0, this.tileSize, this.tileSize);
        String msg = "x=" + ta.xIndex() + "  y=" + ta.yIndex() + "  zoom=" + ta.zoomLevel();
        g.setFont(new Font("Avenir", 0, 32));
        g.drawString(msg, 30, 30);
        return img;
    }
}

