/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;
import org.mitre.caasd.commons.maps.TileAddress;
import org.mitre.caasd.commons.maps.TileServer;
import org.mitre.caasd.commons.util.Suppliers;

public class MapBoxApi
implements TileServer {
    public static final String MAPBOX_ACCESS_TOKEN_KEY = "MAPBOX_ACCESS_TOKEN";
    private static final Supplier<String> TOKEN_SUPPLIER = Suppliers.stringSupplierChain("MAPBOX_ACCESS_TOKEN", new File(System.getProperty("user.dir"), "mapbox.token"));
    private final Style mappingStyle;

    public MapBoxApi(Style mappingStyle) {
        this.mappingStyle = mappingStyle;
    }

    @Override
    public int maxZoomLevel() {
        return 18;
    }

    @Override
    public int maxTileSize() {
        return 512;
    }

    @Override
    public URL getUrlFor(TileAddress ta) {
        String url = "https://api.mapbox.com/styles/v1/mapbox/" + this.mappingStyle.urlComponent() + "/tiles/512/" + ta.tileUrlComponent() + "/?access_token=" + TOKEN_SUPPLIER.get();
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Style {
        STREETS("streets-v11"),
        OUTDOORS("outdoors-v11"),
        LIGHT("light-v10"),
        DARK("dark-v10"),
        SATELLITE("satellite-v9"),
        SATELLITE_STREETS("satellite-streets-v11");

        private final String url;

        private Style(String url) {
            this.url = url;
        }

        public String urlComponent() {
            return this.url;
        }
    }
}

