/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.collect.Lists;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.MapFeature;
import org.mitre.caasd.commons.maps.PixelLatLong;

public class MapFeatures {
    public static MapFeature filledCircle(LatLong loc, Color c, int diameterInPixels) {
        return new Circle(loc, c, diameterInPixels, true, 1.0f);
    }

    public static MapFeature circle(LatLong loc, Color c, int diameterInPixels, float strokeLineWidth) {
        return new Circle(loc, c, diameterInPixels, false, strokeLineWidth);
    }

    public static MapFeature line(LatLong from, LatLong to, Color c, float lineWidth) {
        return new Line(from, to, c, lineWidth);
    }

    public static MapFeature rect(LatLong topLeft, LatLong bottomRight, Color c, float lineWidth) {
        return new Rect(topLeft, bottomRight, c, lineWidth);
    }

    public static MapFeature text(String text, LatLong anchor, Color c) {
        return new TextLabel(text, anchor, c, new Font("Avenir", 0, 32));
    }

    public static MapFeature text(String text, LatLong anchor, Color c, Font font) {
        return new TextLabel(text, anchor, c, font);
    }

    public static MapFeature text(String text, int xOffset, int yOffset, Color c) {
        return new InfoText(text, xOffset, yOffset, c, new Font("Avenir", 0, 32));
    }

    public static MapFeature text(String text, int xOffset, int yOffset, Color c, Font font) {
        return new InfoText(text, xOffset, yOffset, c, font);
    }

    public static MapFeature shape(List<LatLong> pts, Color c) {
        return new Polygon(pts, c, false);
    }

    public static MapFeature filledShape(List<LatLong> pts, Color c) {
        return new Polygon(pts, c, true);
    }

    public static List<MapFeature> shapeWithOutline(List<LatLong> points, Color fillColor, Color borderColor) {
        return Lists.newArrayList((Object[])new MapFeature[]{MapFeatures.filledShape(points, fillColor), MapFeatures.shape(points, borderColor)});
    }

    public static MapFeature path(List<LatLong> pts, Color c, float strokeWidth) {
        return new Path(pts, c, strokeWidth);
    }

    public static MapFeature compose(Collection<MapFeature> features) {
        return new CompositeFeature(features);
    }

    private static PixelLatLong toPixel(LatLong loc, PixelLatLong zero) {
        return new PixelLatLong(loc, zero.zoom(), zero.tileSize());
    }

    private static class CompositeFeature
    implements MapFeature {
        List<MapFeature> features;

        CompositeFeature(Collection<MapFeature> componentFeatures) {
            Objects.requireNonNull(componentFeatures);
            this.features = Lists.newArrayList(componentFeatures);
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            this.features.forEach(feature -> feature.drawOn(g, zeroPixel));
        }
    }

    private static class InfoText
    implements MapFeature {
        final String text;
        final int xOffset;
        final int yOffset;
        final Color color;
        final Font font;

        InfoText(String text, int xOffset, int yOffset, Color color, Font font) {
            this.text = text;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.color = color;
            this.font = font;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            g.setColor(this.color);
            g.setFont(this.font);
            g.drawString(this.text, this.xOffset, this.yOffset);
        }
    }

    private static class TextLabel
    implements MapFeature {
        final String text;
        final LatLong anchor;
        final Color color;
        final Font font;

        TextLabel(String text, LatLong anchor, Color color, Font font) {
            this.text = text;
            this.anchor = anchor;
            this.color = color;
            this.font = font;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            PixelLatLong pixelAnchor = new PixelLatLong(this.anchor, zeroPixel.zoom(), zeroPixel.tileSize());
            g.setColor(this.color);
            g.setFont(this.font);
            g.drawString(this.text, pixelAnchor.x(zeroPixel), pixelAnchor.y(zeroPixel));
        }
    }

    private static class Path
    implements MapFeature {
        final List<LatLong> vertices;
        final Color color;
        final Float strokeWidth;

        Path(List<LatLong> vertices, Color color, float strokeWidth) {
            Objects.requireNonNull(vertices);
            Objects.requireNonNull(color);
            this.vertices = vertices;
            this.color = color;
            this.strokeWidth = Float.valueOf(strokeWidth);
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.strokeWidth.floatValue(), 1, 1));
            int n = this.vertices.size();
            int[] xArray = new int[n];
            int[] yArray = new int[n];
            for (int i = 0; i < n; ++i) {
                PixelLatLong pixel = MapFeatures.toPixel(this.vertices.get(i), zeroPixel);
                xArray[i] = pixel.x(zeroPixel);
                yArray[i] = pixel.y(zeroPixel);
            }
            GeneralPath polyline = new GeneralPath(0, n);
            polyline.moveTo(xArray[0], yArray[0]);
            for (int i = 1; i < n; ++i) {
                polyline.lineTo(xArray[i], yArray[i]);
            }
            g.draw(polyline);
        }
    }

    private static class Polygon
    implements MapFeature {
        List<LatLong> vertices;
        Color color;
        boolean isFilled;

        Polygon(List<LatLong> vertices, Color color, boolean isFilled) {
            Objects.requireNonNull(vertices);
            Objects.requireNonNull(color);
            this.vertices = vertices;
            this.color = color;
            this.isFilled = isFilled;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            g.setColor(this.color);
            int n = this.vertices.size();
            int[] xArray = new int[n];
            int[] yArray = new int[n];
            for (int i = 0; i < n; ++i) {
                PixelLatLong pixel = MapFeatures.toPixel(this.vertices.get(i), zeroPixel);
                xArray[i] = pixel.x(zeroPixel);
                yArray[i] = pixel.y(zeroPixel);
            }
            java.awt.Polygon shape = new java.awt.Polygon(xArray, yArray, xArray.length);
            if (this.isFilled) {
                g.fill(shape);
            } else {
                g.draw(shape);
            }
        }
    }

    private static class Rect
    implements MapFeature {
        final LatLong topLeft;
        final LatLong bottomRight;
        final Color color;
        final float strokeWidth;

        Rect(LatLong topLeft, LatLong bottomRight, Color color, float strokeWidth) {
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
            this.color = color;
            this.strokeWidth = strokeWidth;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            PixelLatLong topLeftPixel = new PixelLatLong(this.topLeft, zeroPixel.zoom(), zeroPixel.tileSize());
            PixelLatLong bottomRightPixel = new PixelLatLong(this.bottomRight, zeroPixel.zoom(), zeroPixel.tileSize());
            int width = (int)(bottomRightPixel.x() - topLeftPixel.x());
            int height = (int)(bottomRightPixel.y() - topLeftPixel.y());
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.strokeWidth, 1, 1));
            g.drawRect(topLeftPixel.x(zeroPixel), topLeftPixel.y(zeroPixel), width, height);
        }
    }

    private static class Line
    implements MapFeature {
        final LatLong from;
        final LatLong to;
        final Color color;
        final float strokeWidth;

        Line(LatLong from, LatLong to, Color color, float strokeWidth) {
            this.from = from;
            this.to = to;
            this.color = color;
            this.strokeWidth = strokeWidth;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            PixelLatLong start = new PixelLatLong(this.from, zeroPixel.zoom(), zeroPixel.tileSize());
            PixelLatLong end = new PixelLatLong(this.to, zeroPixel.zoom(), zeroPixel.tileSize());
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.strokeWidth, 1, 1));
            g.drawLine(start.x(zeroPixel), start.y(zeroPixel), end.x(zeroPixel), end.y(zeroPixel));
        }
    }

    private static class Circle
    implements MapFeature {
        final LatLong loc;
        final Color color;
        final int pixelWidth;
        final boolean isFilled;
        final float strokeWidth;

        public Circle(LatLong loc, Color color, int widthInPixels, boolean isFilled, float strokeWidth) {
            this.loc = loc;
            this.color = color;
            this.pixelWidth = widthInPixels;
            this.isFilled = isFilled;
            this.strokeWidth = strokeWidth;
        }

        @Override
        public void drawOn(Graphics2D g, PixelLatLong zeroPixel) {
            PixelLatLong center = new PixelLatLong(this.loc, zeroPixel.zoom(), zeroPixel.tileSize());
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.strokeWidth, 1, 1));
            int x = center.x(zeroPixel) - this.pixelWidth / 2;
            int y = center.y(zeroPixel) - this.pixelWidth / 2;
            if (this.isFilled) {
                g.fillOval(x, y, this.pixelWidth, this.pixelWidth);
            } else {
                g.drawOval(x, y, this.pixelWidth, this.pixelWidth);
            }
        }
    }
}

