/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.TileAddress;

public class PixelLatLong {
    private final LatLong location;
    private final double pixelX;
    private final double pixelY;
    private final int zoom;
    private final int tileSize;

    public PixelLatLong(LatLong position, int zoom, int tileSize) {
        Objects.requireNonNull(position);
        Preconditions.checkArgument((0 <= zoom && zoom <= 25 ? 1 : 0) != 0);
        Preconditions.checkArgument((32 <= tileSize && tileSize <= 1024 ? 1 : 0) != 0);
        this.location = position;
        this.zoom = zoom;
        this.tileSize = tileSize;
        double x = (position.longitude() + 180.0) / 360.0;
        double sinLatitude = Math.sin(position.latitude() * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        double mapSize = PixelLatLong.mapSize(zoom, tileSize);
        this.pixelX = PixelLatLong.clip(x * mapSize + 0.5, 0.0, mapSize - 1.0);
        this.pixelY = PixelLatLong.clip(y * mapSize + 0.5, 0.0, mapSize - 1.0);
    }

    public PixelLatLong(double x, double y, int zoom, int tileSize) {
        this.zoom = zoom;
        this.tileSize = tileSize;
        int mapSize = PixelLatLong.mapSize(zoom, tileSize);
        Preconditions.checkArgument((0.0 <= x && x <= (double)mapSize ? 1 : 0) != 0);
        Preconditions.checkArgument((0.0 <= y && y <= (double)mapSize ? 1 : 0) != 0);
        double x_for_longitude = PixelLatLong.clip(x, 0.0, mapSize - 1) / (double)mapSize - 0.5;
        double y_for_latitude = 0.5 - PixelLatLong.clip(y, 0.0, mapSize - 1) / (double)mapSize;
        this.location = LatLong.of(90.0 - 360.0 * Math.atan(Math.exp(-y_for_latitude * 2.0 * Math.PI)) / Math.PI, 360.0 * x_for_longitude);
        double x2 = (this.location.longitude() + 180.0) / 360.0;
        double sinLatitude = Math.sin(this.location.latitude() * Math.PI / 180.0);
        double y2 = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        this.pixelX = PixelLatLong.clip(x2 * (double)mapSize + 0.5, 0.0, mapSize - 1);
        this.pixelY = PixelLatLong.clip(y2 * (double)mapSize + 0.5, 0.0, mapSize - 1);
    }

    public double x() {
        return this.pixelX;
    }

    public double y() {
        return this.pixelY;
    }

    public int x(PixelLatLong zeroPixelAnchor) {
        Objects.requireNonNull(zeroPixelAnchor);
        Preconditions.checkArgument((zeroPixelAnchor.tileSize == this.tileSize ? 1 : 0) != 0);
        Preconditions.checkArgument((zeroPixelAnchor.zoom == this.zoom ? 1 : 0) != 0);
        return (int)(this.x() - zeroPixelAnchor.x());
    }

    public int y(PixelLatLong zeroPixelAnchor) {
        Objects.requireNonNull(zeroPixelAnchor);
        Preconditions.checkArgument((zeroPixelAnchor.tileSize == this.tileSize ? 1 : 0) != 0);
        Preconditions.checkArgument((zeroPixelAnchor.zoom == this.zoom ? 1 : 0) != 0);
        return (int)(this.y() - zeroPixelAnchor.y());
    }

    public LatLong latLong() {
        return this.location;
    }

    public int zoom() {
        return this.zoom;
    }

    public int tileSize() {
        return this.tileSize;
    }

    public TileAddress hostTile() {
        return TileAddress.of(this.location, this.zoom);
    }

    public static int mapSize(double zoom, int tileSize) {
        return (int)Math.ceil((double)tileSize * Math.pow(2.0, zoom));
    }

    private static double clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public String toString() {
        return this.location.toString() + " --> " + this.pixelX + ", " + this.pixelY;
    }
}

