/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.TileAddress;
import org.mitre.caasd.commons.util.DemotedException;

public interface TileServer {
    public int maxZoomLevel();

    public int maxTileSize();

    public URL getUrlFor(TileAddress var1);

    default public BufferedImage downloadMap(TileAddress ta) {
        URL url = this.getUrlFor(ta);
        try {
            InputStream inStream = url.openConnection().getInputStream();
            return ImageIO.read(inStream);
        }
        catch (IOException e) {
            throw DemotedException.demote("Could not query: " + url.getQuery(), e);
        }
    }

    default public BufferedImage downloadMap(LatLong pointInTile, int zoom) throws IOException {
        TileAddress tile = TileAddress.of(pointInTile, zoom);
        return this.downloadMap(tile);
    }

    default public BufferedImage downloadAndCombineTiles(List<TileAddress> tiles) {
        Objects.requireNonNull(tiles);
        Preconditions.checkArgument((!tiles.isEmpty() ? 1 : 0) != 0);
        TileAddress topLeftTile = tiles.stream().min(TileAddress.cornerFinder()).get();
        TileAddress bottomRightTile = tiles.stream().max(TileAddress.cornerFinder()).get();
        int size = this.maxTileSize();
        BufferedImage combined = new BufferedImage(size * (bottomRightTile.xIndex() - topLeftTile.xIndex() + 1), size * (bottomRightTile.yIndex() - topLeftTile.yIndex() + 1), 5);
        Graphics2D g = (Graphics2D)combined.getGraphics();
        int xOffset = topLeftTile.xIndex();
        int yOffset = topLeftTile.yIndex();
        for (TileAddress tile : tiles) {
            BufferedImage img = this.downloadMap(tile);
            int imgCol = tile.xIndex() - xOffset;
            int imgRow = tile.yIndex() - yOffset;
            g.drawImage(img, imgCol * size, imgRow * size, size, size, null);
        }
        return combined;
    }
}

