/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import org.mitre.caasd.commons.math.DataSplitter;
import org.mitre.caasd.commons.math.XyDataset;

public class FastLinearApproximation {
    List<Double> xData;
    List<Double> yData;
    private final int n;
    private final double halfWidth;
    private final double middleX;
    private final double avgY;
    private double bestSlope;
    private double error;

    public FastLinearApproximation(List<Double> xData, List<Double> yData) {
        DataSplitter.checkInputData(xData, yData);
        Preconditions.checkArgument((!xData.isEmpty() ? 1 : 0) != 0);
        this.xData = xData;
        this.yData = yData;
        this.n = xData.size();
        double width = xData.get(this.n - 1) - xData.get(0);
        this.halfWidth = width / 2.0;
        this.middleX = this.xData.get(0) + this.halfWidth;
        this.avgY = this.computeAverageY();
        this.computeSlopeAndError();
    }

    public FastLinearApproximation(XyDataset data) {
        this(data.xData(), data.yData());
    }

    private double computeAverageY() {
        DoubleSummaryStatistics dss = new DoubleSummaryStatistics();
        this.yData.stream().mapToDouble(x -> x).forEach(dss);
        return dss.getAverage();
    }

    private void computeSlopeAndError() {
        double lowSlope = this.avgY / this.halfWidth;
        double lowSlopeError = this.sumSquaredErrorGivenSlope(lowSlope);
        double highSlope = -this.avgY / this.halfWidth;
        double highSlopeError = this.sumSquaredErrorGivenSlope(highSlope);
        while (Math.abs(lowSlope - highSlope) > 1.0E-5) {
            if (lowSlopeError < highSlopeError) {
                highSlope = (lowSlope + highSlope) / 2.0;
                highSlopeError = this.sumSquaredErrorGivenSlope(highSlope);
                continue;
            }
            lowSlope = (lowSlope + highSlope) / 2.0;
            lowSlopeError = this.sumSquaredErrorGivenSlope(lowSlope);
        }
        this.bestSlope = lowSlopeError < highSlopeError ? lowSlope : highSlope;
        this.error = Double.min(lowSlopeError, highSlopeError);
    }

    double sumSquaredErrorGivenSlope(double assumedSlope) {
        double totalSumSquareError = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double predictedY = this.avgY + (this.xData.get(i) - this.middleX) * assumedSlope;
            double actualY = this.yData.get(i);
            double err = predictedY - actualY;
            totalSumSquareError += err * err;
        }
        return totalSumSquareError;
    }

    public double slope() {
        return this.bestSlope;
    }

    public double averageY() {
        return this.avgY;
    }

    public double totalSquaredError() {
        return this.error;
    }

    public double avgSquaredError() {
        return this.error / (double)this.n;
    }

    public double predictY(double xValue) {
        return (xValue - this.middleX) * this.bestSlope + this.avgY;
    }

    public double minX() {
        return this.xData.get(0);
    }

    public double midpointX() {
        return this.middleX;
    }

    public double maxX() {
        return this.xData.get(this.n - 1);
    }
}

