/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.mitre.caasd.commons.math.DataSplitter;

public class PiecewiseLinearSplitter
implements DataSplitter {
    private static final int NO_MORE_SPLITS = -1;
    private final double maxFinalError;

    public PiecewiseLinearSplitter(double maxError) {
        this.maxFinalError = maxError;
    }

    @Override
    public int[] computeSplitsFor(List<Double> xData, List<Double> yData) {
        DataSplitter.checkInputData(xData, yData);
        int n = xData.size();
        TreeSet boundaryIndexValues = Sets.newTreeSet();
        boundaryIndexValues.add(0);
        boundaryIndexValues.add(n);
        this.recursivelySplitDataset(xData, yData, 0, n, boundaryIndexValues);
        return Ints.toArray((Collection)boundaryIndexValues);
    }

    private void recursivelySplitDataset(List<Double> xData, List<Double> yData, int minIndex, int maxIndex, TreeSet<Integer> chops) {
        int splitIndex = this.determineSplitFor(xData, yData, minIndex, maxIndex);
        if (splitIndex == -1) {
            return;
        }
        chops.add(splitIndex);
        this.recursivelySplitDataset(xData, yData, minIndex, splitIndex, chops);
        this.recursivelySplitDataset(xData, yData, splitIndex, maxIndex, chops);
    }

    private int determineSplitFor(List<Double> xData, List<Double> yData, int minIndex, int maxIndex) {
        Preconditions.checkArgument((minIndex < maxIndex ? 1 : 0) != 0);
        if (maxIndex - minIndex < 4) {
            return -1;
        }
        double x0 = xData.get(minIndex);
        double y0 = yData.get(minIndex);
        double xN = xData.get(maxIndex - 1);
        double yN = yData.get(maxIndex - 1);
        double slope = (yN - y0) / (xN - x0);
        double maxError = Double.NEGATIVE_INFINITY;
        int indexOfMaxError = -1;
        for (int i = minIndex + 1; i < maxIndex - 2; ++i) {
            double actualY;
            double prediction = y0 + (xData.get(i) - x0) * slope;
            double error = Math.abs(prediction - (actualY = yData.get(i).doubleValue()));
            if (!(error > maxError)) continue;
            indexOfMaxError = i;
            maxError = error;
        }
        return maxError > this.maxFinalError ? indexOfMaxError + 1 : -1;
    }
}

