/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;

public class ReservoirSampler<T> {
    private int numItemsSeen;
    List sample;
    int k;
    Random rng;

    public ReservoirSampler(int k, Random rng) {
        Preconditions.checkArgument((k >= 0 ? 1 : 0) != 0, (Object)"k must be positive");
        Preconditions.checkNotNull((Object)rng);
        this.numItemsSeen = 0;
        this.sample = Lists.newArrayList();
        this.k = k;
        this.rng = rng;
    }

    public void observe(T item) {
        ++this.numItemsSeen;
        if (this.sample.size() < this.k) {
            this.sample.add(item);
            return;
        }
        int randomDraw = this.rng.nextInt(this.numItemsSeen);
        if (randomDraw < this.k) {
            this.sample.set(randomDraw, item);
        }
    }

    public List<T> currentSample() {
        return Lists.newArrayList((Iterable)this.sample);
    }

    public int k() {
        return this.k;
    }

    public int numObservations() {
        return this.numItemsSeen;
    }
}

