/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PriorityQueue;
import org.apache.commons.math3.util.FastMath;
import org.mitre.caasd.commons.collect.HashedLinkedSequence;
import org.mitre.caasd.commons.math.XyDataset;
import org.mitre.caasd.commons.math.XyPoint;
import org.mitre.caasd.commons.math.XyzPoint;

public class VisvalingamSimplifier {
    public XyDataset simplify(XyDataset dataset, double removalThreshold) {
        Preconditions.checkNotNull((Object)dataset);
        Preconditions.checkArgument((removalThreshold >= 0.0 ? 1 : 0) != 0);
        ArrayList<XyPoint> points = dataset.asXyPointList();
        HashedLinkedSequence<XyPoint> hashedSequence = HashedLinkedSequence.newHashedLinkedSequence(points);
        PriorityQueue<Triangle> triangleQueue = this.initalizeTriangles(points);
        while (!triangleQueue.isEmpty() && triangleQueue.peek().area < removalThreshold) {
            Triangle lowAreaTriangle = triangleQueue.poll();
            if (!hashedSequence.containsAll(lowAreaTriangle.points())) continue;
            XyPoint pointToRemove = lowAreaTriangle.center;
            XyPoint left = hashedSequence.getElementBefore(pointToRemove);
            XyPoint right = hashedSequence.getElementAfter(pointToRemove);
            XyPoint leftOfLeft = left == hashedSequence.getFirst() ? null : hashedSequence.getElementBefore(left);
            XyPoint rightOfRight = right == hashedSequence.getLast() ? null : hashedSequence.getElementAfter(right);
            hashedSequence.remove(lowAreaTriangle.center);
            if (leftOfLeft != null) {
                triangleQueue.add(new Triangle(leftOfLeft, left, right));
            }
            if (rightOfRight == null) continue;
            triangleQueue.add(new Triangle(left, right, rightOfRight));
        }
        return XyPoint.asDataset(hashedSequence);
    }

    private PriorityQueue<Triangle> initalizeTriangles(ArrayList<XyPoint> points) {
        PriorityQueue<Triangle> triangleQueue = new PriorityQueue<Triangle>();
        for (int i = 1; i < points.size() - 1; ++i) {
            Triangle tri = new Triangle(points.get(i - 1), points.get(i), points.get(i + 1));
            triangleQueue.add(tri);
        }
        return triangleQueue;
    }

    public static double computeTriangleArea(XyPoint left, XyPoint center, XyPoint right) {
        Preconditions.checkArgument((left.x < center.x ? 1 : 0) != 0);
        Preconditions.checkArgument((center.x < right.x ? 1 : 0) != 0);
        double width = right.x - left.x;
        double rise = right.y - left.y;
        double slope = rise / width;
        double predictedCenterY = slope * (center.x - left.x) + left.y;
        double error = Math.abs(center.y - predictedCenterY);
        return 0.5 * error * width;
    }

    public static double computeTriangleArea(XyzPoint left, XyzPoint center, XyzPoint right) {
        Preconditions.checkArgument((left.x < center.x ? 1 : 0) != 0);
        Preconditions.checkArgument((center.x < right.x ? 1 : 0) != 0);
        double width = right.x - left.x;
        double yDelta = right.y - left.y;
        double ySlope = yDelta / width;
        double predictedCenterY = ySlope * (center.x - left.x) + left.y;
        double zDelta = right.z - left.z;
        double zSlope = zDelta / width;
        double predictedCenterZ = zSlope * (center.x - left.x) + left.z;
        double error = FastMath.hypot((double)(center.y - predictedCenterY), (double)(center.z - predictedCenterZ));
        return 0.5 * error * width;
    }

    private static class Triangle
    implements Comparable<Triangle> {
        XyPoint left;
        XyPoint center;
        XyPoint right;
        double area;

        Triangle(XyPoint left, XyPoint center, XyPoint right) {
            this.left = (XyPoint)Preconditions.checkNotNull((Object)left);
            this.center = (XyPoint)Preconditions.checkNotNull((Object)center);
            this.right = (XyPoint)Preconditions.checkNotNull((Object)right);
            this.area = VisvalingamSimplifier.computeTriangleArea(left, center, right);
        }

        @Override
        public int compareTo(Triangle other) {
            return Doubles.compare((double)this.area, (double)other.area);
        }

        public Collection<XyPoint> points() {
            return Lists.newArrayList((Object[])new XyPoint[]{this.left, this.center, this.right});
        }

        public String toString() {
            return this.left.toString() + " to " + this.center.toString() + " to " + this.right.toString() + "\n area: " + this.area;
        }
    }
}

