/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import java.util.ArrayList;
import java.util.Collection;
import org.mitre.caasd.commons.math.XyDataset;

public class XyPoint {
    final double x;
    final double y;

    public XyPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static XyPoint of(double x, double y) {
        return new XyPoint(x, y);
    }

    public static XyDataset asDataset(Collection<XyPoint> xyData) {
        ArrayList<Double> xData = new ArrayList<Double>(xyData.size());
        ArrayList<Double> yData = new ArrayList<Double>(xyData.size());
        for (XyPoint xyPoint : xyData) {
            xData.add(xyPoint.x());
            yData.add(xyPoint.y());
        }
        return new XyDataset(xData, yData);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + " , " + this.y + ")";
    }
}

