/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math.locationfit;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.mitre.caasd.commons.TimeWindow;

public class GaussianWindow {
    private final Duration windowSize;
    private final double sigmaInMilli;

    public GaussianWindow(Duration windowSize) {
        Objects.requireNonNull(windowSize);
        this.windowSize = windowSize;
        this.sigmaInMilli = windowSize.toMillis() / 6L;
    }

    public Double computeGaussianWeight(Instant centerOfWindow, Instant queryTime) {
        long diff = Math.abs(queryTime.toEpochMilli() - centerOfWindow.toEpochMilli());
        double zScore = (double)diff / this.sigmaInMilli;
        return Math.exp(-(zScore * zScore) / 2.0);
    }

    public TimeWindow windowCenteredAt(Instant center) {
        long halfWidth = this.windowSize.toMillis() / 2L;
        return TimeWindow.of(center.minusMillis(halfWidth), center.plusMillis(halfWidth));
    }

    public Duration sigma() {
        return Duration.ofMillis((long)this.sigmaInMilli);
    }
}

