/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math.locationfit;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.KineticPosition;
import org.mitre.caasd.commons.KineticRecord;
import org.mitre.caasd.commons.Position;
import org.mitre.caasd.commons.PositionRecord;

public interface PositionInterpolator {
    public Optional<KineticPosition> interpolate(List<Position> var1, Instant var2);

    default public <T> Optional<KineticRecord<T>> floorInterpolate(List<PositionRecord<T>> positionData, Instant sampleTime) {
        List<Position> positions = positionData.stream().map(PositionRecord::position).collect(Collectors.toList());
        Optional<KineticPosition> kinetics = this.interpolate(positions, sampleTime);
        if (!kinetics.isPresent()) {
            return Optional.empty();
        }
        PositionRecord<T> floor = HasTime.floor(positionData, sampleTime);
        KineticRecord<T> kr = new KineticRecord<T>(floor.datum(), kinetics.get());
        return Optional.of(kr);
    }
}

