/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.out;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.function.Consumer;
import org.mitre.caasd.commons.Functions;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.util.DemotedException;

public class FileSink
implements Consumer<String> {
    private final String outputDirectory;
    private final Functions.ToStringFunction<String> fileNamer;

    public FileSink(String outputDirectory, Functions.ToStringFunction<String> fileNamer) {
        this.outputDirectory = outputDirectory;
        this.fileNamer = (Functions.ToStringFunction)Preconditions.checkNotNull(fileNamer, (Object)"The file-naming function cannot be null");
    }

    @Override
    public void accept(String message) {
        FileUtils.makeDirIfMissing(this.outputDirectory);
        String fileName = (String)this.fileNamer.apply(message);
        String fullFileName = this.outputDirectory + File.separator + fileName + ".txt";
        try {
            FileUtils.appendToFile(fullFileName, message + "\n");
        }
        catch (Exception ex) {
            throw DemotedException.demote("Error writing message to FileSink, fileName = " + fileName, ex);
        }
    }
}

