/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public interface AutoCloseableIterator<T>
extends AutoCloseable,
Iterator<T> {
    public static <T, C extends Iterator<T> & AutoCloseable> AutoCloseableIterator<T> wrap(final C autoCloseableAndIterator) {
        Objects.requireNonNull(autoCloseableAndIterator);
        return new AutoCloseableIterator<T>(){

            @Override
            public void close() throws Exception {
                ((AutoCloseable)((Object)autoCloseableAndIterator)).close();
            }

            @Override
            public boolean hasNext() {
                return autoCloseableAndIterator.hasNext();
            }

            @Override
            public T next() {
                return autoCloseableAndIterator.next();
            }

            @Override
            public void remove() {
                autoCloseableAndIterator.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                autoCloseableAndIterator.forEachRemaining(consumer);
            }
        };
    }

    public static <U, T> AutoCloseableIterator<T> transforming(final AutoCloseableIterator<U> autoCloseableIterator, final Function<U, T> transform) {
        Objects.requireNonNull(autoCloseableIterator, "Supplied iterator cannot be null.");
        Objects.requireNonNull(transform, "Supplied transform cannot be null");
        return new AutoCloseableIterator<T>(){

            @Override
            public void close() throws Exception {
                autoCloseableIterator.close();
            }

            @Override
            public boolean hasNext() {
                return autoCloseableIterator.hasNext();
            }

            @Override
            public T next() {
                return transform.apply(autoCloseableIterator.next());
            }

            @Override
            public void remove() {
                autoCloseableIterator.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                autoCloseableIterator.forEachRemaining((? super E element) -> consumer.accept((Object)transform.apply(element)));
            }
        };
    }
}

