/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BitAndHashingUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.farmHashFingerprint64();
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    public static long compute64BitHash(String str, Charset charset, HashFunction hashFunc) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        hasher.putString((CharSequence)str, UTF8);
        HashCode hash = hasher.hash();
        return hash.asLong();
    }

    public static long compute64BitHash(String str) {
        return BitAndHashingUtils.compute64BitHash(str, UTF8, HASH_FUNCTION);
    }

    public static long nRandomBitsFrom(int n, String str) {
        Preconditions.checkArgument((0 < n && n <= 64 ? 1 : 0) != 0);
        long hash = BitAndHashingUtils.compute64BitHash(str);
        return BitAndHashingUtils.truncateBits(hash, n);
    }

    public static long truncateBits(long bits, int n) {
        Preconditions.checkArgument((0 < n && n <= 64 ? 1 : 0) != 0);
        return BitAndHashingUtils.makeBitMask(n) & bits;
    }

    public static long makeBitMask(int n) {
        Preconditions.checkArgument((0 < n && n <= 64 ? 1 : 0) != 0);
        long mask = 0L;
        for (int i = 0; i < n; ++i) {
            mask <<= 1;
            mask |= 1L;
        }
        return mask;
    }
}

