/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import org.mitre.caasd.commons.util.Translator;

public class CompositeTranslator<A, B, C>
implements Translator<A, C> {
    private final Translator<A, B> step1;
    private final Translator<B, C> step2;

    public CompositeTranslator(Translator<A, B> step1, Translator<B, C> step2) {
        this.step1 = step1;
        this.step2 = step2;
    }

    @Override
    public C to(A item) {
        B middle = this.step1.to(item);
        C result = this.step2.to(middle);
        return result;
    }

    @Override
    public A from(C item) {
        B middle = this.step2.from(item);
        A result = this.step1.from(middle);
        return result;
    }
}

