/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.util.ExceptionHandler;

public class DailySequentialFileWriter
implements ExceptionHandler {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("America/New_York");
    private static final String NEW_LINE_CHAR = System.lineSeparator();
    private static final String FOOTER = NEW_LINE_CHAR + "- - - - - - - - - - - - - - - - - -" + NEW_LINE_CHAR;
    private static final int MAX_STACK_TRACE_DEPTH = 8;
    private final String targetDirectory;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter timeFormatter;
    private final int maxStackTraceDepthToPrint;

    public DailySequentialFileWriter(String targetDirectory) {
        this(targetDirectory, DEFAULT_ZONE_ID, 8);
    }

    public DailySequentialFileWriter(String targetDirectory, ZoneId zoneId) {
        this(targetDirectory, zoneId, 8);
    }

    public DailySequentialFileWriter(String targetDirectory, ZoneId zoneId, int maxStackTraceDepthToPrint) {
        this.targetDirectory = (String)Preconditions.checkNotNull((Object)targetDirectory);
        this.dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(zoneId);
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss z").withZone(zoneId);
        this.maxStackTraceDepthToPrint = maxStackTraceDepthToPrint;
        FileUtils.makeDirIfMissing(targetDirectory);
    }

    @Override
    public void warn(String message) {
        Instant now = Instant.now();
        StringBuilder sb = new StringBuilder();
        sb.append(this.header("WARNING", now));
        sb.append(this.indent(message));
        sb.append(FOOTER);
        this.writeTo(this.currentFile(now), sb.toString());
    }

    @Override
    public void handle(String message, Exception traceMe) {
        Instant now = Instant.now();
        StringBuilder sb = new StringBuilder();
        sb.append(this.header("ERROR", now));
        if (Objects.nonNull(message)) {
            sb.append(this.indent(message));
        }
        sb.append(this.indent(this.truncatedStackTrace(traceMe)));
        sb.append(FOOTER);
        this.writeTo(this.currentFile(now), sb.toString());
    }

    private String header(String type, Instant now) {
        return "## " + type + " @ " + this.timeFormatter.format(now) + "  ##" + NEW_LINE_CHAR;
    }

    private String indent(String message) {
        return "\t" + String.join((CharSequence)(NEW_LINE_CHAR + "\t"), message.split("\\R"));
    }

    private File currentFile(Instant now) {
        String filename = "log_for_" + this.dateFormatter.format(now) + ".txt";
        return new File(this.targetDirectory, filename);
    }

    private synchronized void writeTo(File file, String message) {
        try {
            FileUtils.appendToFile(file, message);
        }
        catch (Exception e) {
            System.out.println("Failed to write the following message to: " + file.getName());
            System.out.println(message);
            System.out.println("\nThe following exception was thrown: \n" + e.getMessage());
            System.out.println("\n\n");
        }
    }

    private String truncatedStackTrace(Exception traceMe) {
        CharSequence[] stackTrace = this.stackTraceLines(traceMe);
        if (stackTrace.length == 0) {
            return "";
        }
        String truncated = stackTrace.length < this.maxStackTraceDepthToPrint ? String.join((CharSequence)NEW_LINE_CHAR, stackTrace) : String.join((CharSequence)NEW_LINE_CHAR, Arrays.asList(stackTrace).subList(0, this.maxStackTraceDepthToPrint));
        return truncated + NEW_LINE_CHAR + "...";
    }

    private String[] stackTraceLines(Exception traceMe) {
        StringWriter sw = new StringWriter();
        traceMe.printStackTrace(new PrintWriter(sw));
        return sw.toString().split("\\R");
    }
}

