/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

public class DemotedException
extends RuntimeException {
    private static final long serialVersionUID = 9114768309613077242L;

    public DemotedException(Exception cause) {
        super(cause);
        DemotedException.throwOnRuntimeException(cause);
    }

    public DemotedException(String message, Exception cause) {
        super(message, cause);
        DemotedException.throwOnRuntimeException(cause);
    }

    public static DemotedException demote(Exception cause) {
        return new DemotedException(cause);
    }

    public static DemotedException demote(String message, Exception cause) {
        return new DemotedException(message, cause);
    }

    private static void throwOnRuntimeException(Exception cause) {
        if (cause instanceof RuntimeException) {
            throw new IllegalArgumentException("Illegal Use of DemotedException, cannot demote RuntimeExceptions but " + cause.getClass().getSimpleName() + " is an instance of RuntimeException", cause);
        }
    }
}

